﻿// -- FILE ------------------------------------------------------------------
// name       : DropDownList.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;
using System.Web.UI.WebControls;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.DropDownList.png" )]
	public class DropDownList : System.Web.UI.WebControls.DropDownList, IListField
	{

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "DropDownList Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "DropDownList Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return SelectedValue; }
			set
			{
				ListItem listItem = Items.FindByValue( value );
				if ( listItem != null )
				{
					SelectedIndex = Items.IndexOf( listItem );
				}
			}
		} // FieldValue

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit 
		{
			get { return Enabled; }
			set { Enabled = value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;

	} // class DropDownList

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
