﻿// -- FILE ------------------------------------------------------------------
// name       : DatePicker.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;
using System.ComponentModel;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

#if TP_DATE_FIELDS

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.DatePicker.png" )]
	public class DatePicker : System.Web.UI.WebControls.TextBox, IUserFormField, IPlaceholderControl
	{

		// ----------------------------------------------------------------------
		public DatePicker()
		{
			base.ReadOnly = true;
		} // DatePicker

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "DatePicker Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "DatePicker Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return Text; }
			set { Text = value; }
		} // FieldValue

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "DatePicker Form Field Date Format" )]
		[Category( "Web User Forms" )]
		public string DateFormat
		{
			get { return this.dateFormat; }
			set { this.dateFormat = value; }
		} // DateFormat

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "DatePicker Form Field Min Date" )]
		[Category( "Web User Forms" )]
		public DateTime MinDate
		{
			get { return this.minDate; }
			set { this.minDate = value; }
		} // MinDate

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "DatePicker Form Field Max Date" )]
		[Category( "Web User Forms" )]
		public DateTime MaxDate
		{
			get { return this.maxDate; }
			set { this.maxDate = value; }
		} // MaxDate

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return false; }
			set { }
		} // AllowEdit

		// ----------------------------------------------------------------------
		[Browsable( false )]
		Control IPlaceholderControl.Control
		{
			get { return this; }
		} // IPlaceholderControl.Control

		// ----------------------------------------------------------------------
		public override bool ReadOnly
		{
			get { return base.ReadOnly; }
			set { }
		} // ReadOnly

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;
		private string dateFormat;
		private DateTime minDate = new DateTime( 1980, 1, 1 );
		private DateTime maxDate = new DateTime( 2099, 12, 31 );

	} // class DatePicker

#endif // TP_DATE_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
