﻿// -- FILE ------------------------------------------------------------------
// name       : FieldFinder.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class ControlFieldCollector : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		public ControlFieldCollector( Control startControl, string fieldName )
			: base( startControl )
		{
			if ( string.IsNullOrEmpty( fieldName ) )
			{
				throw new ArgumentException( "fieldName" );
			}

			this.fieldName = fieldName;
		} // FieldFinder

		// ----------------------------------------------------------------------
		public string FieldName
		{
			get { return this.fieldName; }
		} // FieldName

		// ----------------------------------------------------------------------
		public List<Control> Controls
		{
			get { return this.controls; }
		} // Controls

		// ----------------------------------------------------------------------
		public void Collect()
		{
			this.controls.Clear();
			Start();
		} // Collect

		// ----------------------------------------------------------------------
		public static List<Control> Collect( Control startControl, string fieldName )
		{
			ControlFieldCollector controlFieldCollector = new ControlFieldCollector( startControl, fieldName );
			controlFieldCollector.Collect();
			return controlFieldCollector.Controls;
		} // Collect

		// ----------------------------------------------------------------------
		protected override void VisitFormField( Control control,
			IUserFormField formField, IUserFormHeader formHeader )
		{
			if ( this.fieldName.Equals( formField.FieldName ) )
			{
				this.controls.Add( control );
			}
		} // VisitFormField

		// ----------------------------------------------------------------------
		// members
		private readonly List<Control> controls = new List<Control>();
		private readonly string fieldName;

	} // class FieldFinder

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
