﻿// -- FILE ------------------------------------------------------------------
// name       : LookupCollector.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Collections.Generic;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

	// ------------------------------------------------------------------------
	public class CommandCollector : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		public CommandCollector( Control startControl )
			: base( startControl )
		{
		} // LookupCollector

		// ----------------------------------------------------------------------
		public List<IUserFormCommand> Commands
		{
			get { return this.commands; }
		} // Commands

		// ----------------------------------------------------------------------
		public void Collect()
		{
			this.commands.Clear();
			Start();
		} // Collect

		// ----------------------------------------------------------------------
		public static List<IUserFormCommand> Collect( Control startControl )
		{
			CommandCollector lookupFieldCollector = new CommandCollector( startControl );
			lookupFieldCollector.Collect();
			return lookupFieldCollector.Commands;
		} // Collect

		// ----------------------------------------------------------------------
		protected override void VisitFormCommand( Control control,
			IUserFormCommand formCommand, IUserFormHeader formHeader )
		{
			this.commands.Add( formCommand );
		} // VisitLookupFormField

		// ----------------------------------------------------------------------
		// members
		private readonly List<IUserFormCommand> commands = new List<IUserFormCommand>();

	} // class LookupCollector

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
