﻿// -- FILE ------------------------------------------------------------------
// name       : ComboBox.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Drawing;
using System.ComponentModel;
using System.Web.UI;

namespace Itenso.WebUserForms.Controls
{

#if TP_COMBO_FIELDS

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.ComboBox.png" )]
	public class ComboBox : System.Web.UI.WebControls.DropDownList, IListField, IPlaceholderControl
	{

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "ComboBox Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "ComboBox Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return ListControlTool.GetSelectionValue( this ); }
			set
			{
				ListControlTool.ResetItemSelection( this );
				ListControlTool.SetSelectionValue( this, value );
			}
		} // FieldValue

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "ComboBox Form Field Custom Text" )]
		[Category( "Web User Forms" )]
		public bool AllowCustomText 
		{
			get { return this.allowCustomText; }
			set { this.allowCustomText = value; }
		} // AllowCustomText 

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "ComboBox Form Field Auto Complete" )]
		[Category( "Web User Forms" )]
		public bool AutoComplete
		{
			get { return this.autoComplete; }
			set { this.autoComplete = value; }
		} // AutoComplete 

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return Enabled; }
			set { Enabled = value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		[Browsable( false )]
		Control IPlaceholderControl.Control
		{
			get { return this; }
		} // IPlaceholderControl.Control

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;
		private bool allowCustomText;
		private bool autoComplete;

	} // class ComboBox

#endif // TP_COMBO_FIELDS

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
