﻿// -- FILE ------------------------------------------------------------------
// name       : Calendar.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;
using System.ComponentModel;

namespace Itenso.WebUserForms.Controls
{
	using System.Globalization;

	// ------------------------------------------------------------------------
	[DefaultProperty( "FieldName" )]
	[Designer( typeof( UserFormFieldDesigner ) )]
	[ToolboxBitmap( typeof( ResFinder ), "Itenso.WebUserForms.Controls.Images.Calendar.png" )]
	public class Calendar : System.Web.UI.WebControls.Calendar, IUserFormField
	{

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "Calendar Form Field Name" )]
		[Category( "Web User Forms" )]
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		[DefaultValue( "" )]
		[Description( "Calendar Form Field Value" )]
		[Category( "Web User Forms" )]
		public string FieldValue
		{
			get { return SelectedDate.ToString( CultureInfo.InvariantCulture ); }
			set { SelectedDate = DateTime.Parse( value ); }
		} // FieldValue

		// ----------------------------------------------------------------------
		[Browsable( false )]
		bool IUserFormField.AllowEdit
		{
			get { return Enabled; }
			set { Enabled = value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;

	} // class Calendar

} // namespace Itenso.WebUserForms.Controls
// -- EOF -------------------------------------------------------------------
