﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace WebAPI.Models
{
    public class BookRepository : IBookRepository
    {
        private List<Book> _books=new List<Book>();
       
        private int _nextId = 1;

        public BookRepository()
        {
            this.Add(new Book() {Name = "MVC4 Getting Started", Price = Convert.ToDecimal(240.45)});
            this.Add(new Book() {Name = "MVC3 Getting Started", Price = Convert.ToDecimal(100.45)});
            this.Add(new Book() {Name = "Web API Getting Started", Price = Convert.ToDecimal(300.45)});
        }

        public IQueryable<Book> GetAll()
        {
            return _books.AsQueryable();
        }

        public Book Get(int id)
        {
            return _books.Find(c => c.Id == id);
        }

        public Book Add(Book book)
        {
            book.Id = _nextId++;
            _books.Add(book);
            return book;
        }

        public void Remove(int id)
        {
            Book book = _books.Find(c => c.Id == id);
            _books.Remove(book);
        }

        public bool Update(Book book)
        {
            int index = _books.FindIndex(c => c.Id == book.Id);
            if (index == -1)
            {
                return false;
            }
            _books.RemoveAt(index);
            _books.Add(book);
            return true;
        }
    }
}