﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;
using Microsoft.Practices.Unity;
using WebAPI.Models;

namespace WebAPI
{
    // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
    // visit http://go.microsoft.com/?LinkId=9394801

    public class WebApiApplication : System.Web.HttpApplication
    {
        public static void RegisterGlobalFilters(GlobalFilterCollection filters)
        {
            filters.Add(new HandleErrorAttribute());
        }

        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            routes.MapHttpRoute(
                name: "DefaultApi",
                routeTemplate: "api/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );

            routes.MapRoute(
                name: "Default",
                url: "{controller}/{action}/{id}",
                defaults: new { controller = "Home", action = "Index", id = UrlParameter.Optional }
            );
        }

        protected void Application_Start()
        {
            RegisterDependencies();

            AreaRegistration.RegisterAllAreas();

            RegisterGlobalFilters(GlobalFilters.Filters);
            RegisterRoutes(RouteTable.Routes);

            BundleTable.Bundles.RegisterTemplateBundles();
        }

        private void RegisterDependencies()
        {
            IUnityContainer container = new UnityContainer();
            container.RegisterInstance<IBookRepository>(new BookRepository());

            GlobalConfiguration.Configuration.ServiceResolver.SetResolver(
                t =>
                    {
                        try
                        {
                            return container.Resolve(t);
                        }
                        catch (ResolutionFailedException)
                        {
                            return null;
                        }
                    },
                t =>
                    {
                        try
                        {
                            return container.ResolveAll(t);
                        }
                        catch (ResolutionFailedException)
                        {
                            return new List<object>();
                        }
                    });
        }
    }
}