using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;

namespace YAMessaging.DAL
{
    public class MessageDb
    {
        public MessageDb()
        {
            
        }

        public DataTable GetAllMessages(string userID)
        {
            return Functions.ExecuteParamerizedSelectCommand("FetchMessages", new SqlParameter[] 
            { 
                new SqlParameter("@recieverId", userID) 
            });
        }


        public bool SendMessage(string userid, string sender, string subject, string body)
        {
            SqlParameter[] parameters = new SqlParameter[]
            {
                new SqlParameter("@recieverId", userid),
                new SqlParameter("@senderId", sender),
                new SqlParameter("@subject", subject),
                new SqlParameter("@body", body)
            };

            return Functions.ExecuteNonQuery("SendMessage", parameters);
        }

        public DataTable GetMessageDetails(string readerId, int messageId)
        {
            SqlParameter[] parameters = new SqlParameter[]
        {
            new SqlParameter("@id", messageId),
            new SqlParameter("@userId", readerId)
        };

            return Functions.ExecuteParamerizedSelectCommand("ReadMessage", parameters);
        }

        public DataTable GetSentMessages(string userID)
        {
            return Functions.ExecuteParamerizedSelectCommand("GetSentMessages", new SqlParameter[] 
            { 
                new SqlParameter("@userId", userID) 
            });
        }

        public bool MarkMessageRead(int msgId)
        {
            SqlParameter[] parameters = new SqlParameter[]
            {
                new SqlParameter("@id", msgId)            
            };

            return Functions.ExecuteNonQuery("MarkAsRead", parameters);
        }
    }
}