using System;
using System.Data;
using System.Configuration;
using YAMessaging.DAL;

namespace YAMessaging.BLL
{
    public class MessageHandler
    {
        MessageDb messageDb = null;

        public MessageHandler()
        {
            messageDb = new MessageDb();
        }

        public DataTable GetAllMessages(string userID)
        {
            return messageDb.GetAllMessages(userID);
        }

        public bool SendMessage(string userid, string sender, string subject, string body)
        {
            return messageDb.SendMessage(userid, sender, subject, body);
        }

        public Message GetMessageDetails(string readerId, int messageId)
        {
            DataTable table = messageDb.GetMessageDetails(readerId, messageId);

            if (table.Rows.Count == 0)
            {
                return null;
            }

            Message msg = new Message();

            msg.Date = Convert.ToDateTime(table.Rows[0]["datentime"].ToString());
            msg.MessageId = Convert.ToInt32(table.Rows[0]["MessageID"].ToString());
            msg.RecieverId = table.Rows[0]["recieverID"].ToString();
            msg.Status = table.Rows[0]["status"].ToString();
            msg.SenderId = table.Rows[0]["senderID"].ToString();
            msg.Subject = table.Rows[0]["subject"].ToString();
            msg.Body = table.Rows[0]["body"].ToString();

            //Before returning lets mark this message as read
            messageDb.MarkMessageRead(messageId);

            return msg;
        }

        public DataTable GetSentMessages(string userID)
        {
            return messageDb.GetSentMessages(userID);
        }
    }
}