using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using YAMessaging.BLL;

public partial class UpdateProfile : System.Web.UI.Page
{
    UserHandler userHandler = new UserHandler();

    protected void Page_Load(object sender, EventArgs e)
    {
        //Check if a user is logged in or not
        if (Session["UserId"] == null)
        {
            Response.Redirect("Login.aspx");
        }

        lblUserId.Text = Session["UserId"].ToString();
        lblUserName.Text = userHandler.GetUserName(Session["UserId"].ToString());

    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if(txtNew.Text != txtrenew.Text)
        {
            //Show some message
            Label1.Text = "New password Entry and rentry doesn't match";
            return;
        }

        bool retVal = userHandler.UpdatePassword(Session["UserId"].ToString(),
                                    EncryptionManager.Encrypt(txtPwd.Text), 
                                    EncryptionManager.Encrypt(txtNew.Text));

        if (retVal == true)
        {
            //Show success message
            Label1.Text = "Password changed Successfully";
        }
        else
        {
            //Show failure message
            Label1.Text = "Your password is wrong, please contact your administrator";
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("Default.aspx");
    }
}
