using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using YAMessaging.BLL;

public partial class Login : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["action"] == null)
        {
            //do nothing
        }
        else if (Request.QueryString["action"] == "logout")
        {
            Session.Remove("UserId");
            Session.Remove("UserName");
            Response.Redirect("login.aspx");
        }
        else if (Request.QueryString["action"] == "login")
        {
            //do nothing for now
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        UserHandler userHandler = new UserHandler();

        string username = txtUserName.Text;
        string password = EncryptionManager.Encrypt(txtPassword.Text);

        if (userHandler.ValidateUser(username, password))
        {
            Session["UserId"] = username;
            Session["UserName"] = userHandler.GetUserName(username);
            Response.Redirect("Default.aspx");
        }
        else
        {
            Label1.Text = "Invalid Username and/or Password";
        }
    }
}
