using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using YAMessaging.BLL;

public partial class AddUser : System.Web.UI.Page
{
    UserHandler userhandler = new UserHandler();

    protected void Page_Load(object sender, EventArgs e)
    {
        //Check if someone is logged in or not
        if (Session["UserId"] == null)
        {
            Response.Redirect("Login.aspx");
        }

        //Check for admin login
        if (Session["UserId"].ToString().Trim() != "admin")
        {
            Response.Redirect("Login.aspx");
        }

        //Everything fine now, let him see the page

        //lets show him the existing users
        lstExistingUsers.DataSource = userhandler.GetUserList();
        lstExistingUsers.DataBind();
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("Default.aspx");
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if(txtNew.Text != txtrenew.Text)
        {
            Label1.Text = "Failed to create new user";
            return;
        }

        string userid = txtUserId.Text.Trim();
        string userName = txtUserName.Text.Trim();
        string password = EncryptionManager.Encrypt(txtNew.Text);

        if (true == userhandler.CreateNewUser(userid, password, userName, Session["UserId"].ToString()))
        {
            Label1.Text = "Successfully created new user";
            
            //let us update the userlist we are showing to the admin
            lstExistingUsers.DataSource = userhandler.GetUserList();
            lstExistingUsers.DataBind();
        }
        else
        {
            Label1.Text = "Failed to create new user";
        }
    }
}
