﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using CValenzuela.Common;

namespace CValenzuelaCommonTests
{
    /// <summary>
    /// Summary description for UnitTest1
    /// </summary>
    public partial class UnitTests
    {
        [TestMethod]
        [Owner("Cvalenzuela")]
        public void StringDefaultValueTest()
        {
            String strTestValueNull = null;
            String strTestValueBlank = String.Empty;
            String strTestValueSpace = " ";
            String strDefaultValue = "CValenzuela";
            String strSomeNonBlankValue = "Holy Rusted Metal BatMan!";

            //Test Null
            Assert.AreEqual(strTestValueNull.Default(strDefaultValue), strDefaultValue);
            //Test String.Empty
            Assert.AreEqual(strTestValueBlank.Default(strDefaultValue), strDefaultValue);
            //Test Whitespace
            Assert.AreEqual(strTestValueSpace.Default(strDefaultValue), strDefaultValue);
            //Test Non blank
            Assert.AreNotEqual(strSomeNonBlankValue.Default(strDefaultValue), strDefaultValue);
        }
    }
}
