﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using CValenzuela.Common;

namespace CValenzuelaCommonTests
{
    /// <summary>
    /// Summary description for UnitTest1
    /// </summary>
    public partial class UnitTests
    {

        private const String strElements = "/*A CSS Comment in its own line*/\r\nbody\r\n{\r\n\tpadding:1px;\r\n\tcolor: red;/*a CSS Comment inline*/\r\n}\r\n a\r\n{\r\n\tcolor: blue;\r\n\tfont-size:20px;\r\n}\r\n";
        private const String strClasses = "/*A CSS Comment in its own line*/\r\n.car\r\n{\r\n\tpadding:1px;\r\n\tcolor: red;/*a CSS Comment inline*/\r\n}\r\n .bike\r\n{\r\n\tcolor: blue;\r\n\tfont-size:20px;\r\n}\r\n";
        private const String strStyles = strElements + strClasses;

        [TestMethod]
        [Owner("Cvalenzuela")]
        public void CSSParserElementTest()
        {
            
            CSSParser parser = new CSSParser();
            parser.Read(strElements);

            Assert.AreEqual(parser.StyleSheet, strElements);
            Assert.IsNotNull(parser.Styles);
            Assert.IsTrue(parser.Classes.Count == 0);
            Assert.IsNotNull(parser.Elements);
            Assert.IsTrue(parser.Elements.Count == 2);

            Assert.AreEqual(parser[0].Key, "body");
            Assert.IsTrue(parser[0].Value.Count == 2);
            Assert.AreEqual(parser[0].Value[0].Key, "padding");
            Assert.AreEqual(parser[0].Value[0].Value, "1px");
            Assert.AreEqual(parser[0].Value[1].Key, "color");
            Assert.AreEqual(parser[0].Value[1].Value, "red");
            Assert.AreEqual(parser.Elements["body"]["padding"], "1px");
            Assert.AreEqual(parser.Elements["body"]["color"], "red");

            Assert.AreEqual(parser[1].Key, "a");
            Assert.IsTrue(parser[1].Value.Count == 2);
            Assert.AreEqual(parser[1].Value[0].Key, "color");
            Assert.AreEqual(parser[1].Value[0].Value, "blue");
            Assert.AreEqual(parser[1].Value[1].Key, "font-size");
            Assert.AreEqual(parser[1].Value[1].Value, "20px");
            Assert.IsTrue(parser[1].Value.Count == 2);
            Assert.AreEqual(parser.Elements["a"]["color"], "blue");
            Assert.AreEqual(parser.Elements["a"]["font-size"], "20px");


        }

        [TestMethod]
        [Owner("Cvalenzuela")]
        public void CSSParserClassTest()
        {            
            CSSParser parser = new CSSParser();
            parser.Read(strClasses);

            Assert.AreEqual(parser.StyleSheet, strClasses);
            Assert.IsNotNull(parser.Styles);
            Assert.IsTrue(parser.Elements.Count == 0);
            Assert.IsNotNull(parser.Classes);
            Assert.IsTrue(parser.Classes.Count == 2);

            Assert.AreEqual(parser[0].Key, ".car");
            Assert.IsTrue(parser[0].Value.Count == 2);
            Assert.AreEqual(parser[0].Value[0].Key, "padding");
            Assert.AreEqual(parser[0].Value[0].Value, "1px");
            Assert.AreEqual(parser[0].Value[1].Key, "color");
            Assert.AreEqual(parser[0].Value[1].Value, "red");
            Assert.AreEqual(parser.Classes["car"]["padding"], "1px");
            Assert.AreEqual(parser.Classes["car"]["color"], "red");

            Assert.AreEqual(parser[1].Key, ".bike");
            Assert.IsTrue(parser[1].Value.Count == 2);
            Assert.AreEqual(parser[1].Value[0].Key, "color");
            Assert.AreEqual(parser[1].Value[0].Value, "blue");
            Assert.AreEqual(parser[1].Value[1].Key, "font-size");
            Assert.AreEqual(parser[1].Value[1].Value, "20px");
            Assert.IsTrue(parser[1].Value.Count == 2);
            Assert.AreEqual(parser.Classes["bike"]["color"], "blue");
            Assert.AreEqual(parser.Classes["bike"]["font-size"], "20px");


        }

        [TestMethod]
        [Owner("Cvalenzuela")]
        public void CSSParserClassAndElementsTest()
        {
            CSSParser parser = new CSSParser();
            parser.Read(strStyles);

            Assert.AreEqual(parser.StyleSheet, strStyles);
            Assert.IsNotNull(parser.Styles);
            Assert.IsNotNull(parser.Elements);
            Assert.IsNotNull(parser.Classes);
            Assert.IsTrue(parser.Elements.Count == 2);            
            Assert.IsTrue(parser.Classes.Count == 2);

            //Loaded Elements First
            Assert.AreEqual(parser[0].Key, "body");
            Assert.IsTrue(parser[0].Value.Count == 2);
            Assert.AreEqual(parser[0].Value[0].Key, "padding");
            Assert.AreEqual(parser[0].Value[0].Value, "1px");
            Assert.AreEqual(parser[0].Value[1].Key, "color");
            Assert.AreEqual(parser[0].Value[1].Value, "red");
            Assert.AreEqual(parser.Elements["body"]["padding"], "1px");
            Assert.AreEqual(parser.Elements["body"]["color"], "red");

            Assert.AreEqual(parser[1].Key, "a");
            Assert.IsTrue(parser[1].Value.Count == 2);
            Assert.AreEqual(parser[1].Value[0].Key, "color");
            Assert.AreEqual(parser[1].Value[0].Value, "blue");
            Assert.AreEqual(parser[1].Value[1].Key, "font-size");
            Assert.AreEqual(parser[1].Value[1].Value, "20px");
            Assert.IsTrue(parser[1].Value.Count == 2);
            Assert.AreEqual(parser.Elements["a"]["color"], "blue");
            Assert.AreEqual(parser.Elements["a"]["font-size"], "20px");

            //Classes
            Assert.AreEqual(parser[2].Key, ".car");
            Assert.IsTrue(parser[2].Value.Count == 2);
            Assert.AreEqual(parser[2].Value[0].Key, "padding");
            Assert.AreEqual(parser[2].Value[0].Value, "1px");
            Assert.AreEqual(parser[2].Value[1].Key, "color");
            Assert.AreEqual(parser[2].Value[1].Value, "red");
            Assert.AreEqual(parser.Classes["car"]["padding"], "1px");
            Assert.AreEqual(parser.Classes["car"]["color"], "red");

            Assert.AreEqual(parser[3].Key, ".bike");
            Assert.IsTrue(parser[3].Value.Count == 2);
            Assert.AreEqual(parser[3].Value[0].Key, "color");
            Assert.AreEqual(parser[3].Value[0].Value, "blue");
            Assert.AreEqual(parser[3].Value[1].Key, "font-size");
            Assert.AreEqual(parser[3].Value[1].Value, "20px");
            Assert.IsTrue(parser[3].Value.Count == 2);
            Assert.AreEqual(parser.Classes["bike"]["color"], "blue");
            Assert.AreEqual(parser.Classes["bike"]["font-size"], "20px");



        }



    }
}
