﻿using System;
namespace CValenzuela.Common
{
    /// <summary>
    /// Creates a PDF Document from HTML and CSS
    /// </summary>
    public interface IPDFDocument
    {
         /// <summary>
        /// Gets or sets the size of the page.
        /// A4 for Letter
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        iTextSharp.text.Rectangle PageSize { get; set; }
       
        /// <summary>
        /// Gets or sets the left margin.
        /// </summary>
        /// <value>
        /// The left margin.
        /// </value>
        Single LeftMargin { get; set; }
     
        /// <summary>
        /// Gets or sets the right margin.
        /// </summary>
        /// <value>
        /// The right margin.
        /// </value>
        Single RightMargin { get; set; }
     
        /// <summary>
        /// Gets or sets the top margin.
        /// </summary>
        /// <value>
        /// The top margin.
        /// </value>
        Single TopMargin { get; set; }
       
        /// <summary>
        /// Gets or sets the bottom margin.
        /// </summary>
        /// <value>
        /// The bottom margin.
        /// </value>
        Single BottomMargin { get; set; }
       
        /// <summary>
        /// Gets or sets the title.
        /// This will also be the file name
        /// </summary>
        /// <value>
        /// The title.
        /// </value>
        String Title { get; set; }
        
        /// <summary>
        /// Gets or sets the subject.
        /// </summary>
        /// <value>
        /// The subject.
        /// </value>
        String Subject { get; set; }
       
        /// <summary>
        /// Gets or sets the creator.
        /// Person tha created the PDF
        /// </summary>
        /// <value>
        /// The creator.
        /// </value>
        String Creator { get; set; }
        
        /// <summary>
        /// Gets or sets the author.
        /// Person that created the document which was turned into PDF
        /// </summary>
        /// <value>
        /// The author.
        /// </value>
        String Author { get; set; }
        
        /// <summary>
        /// Gets or sets the key words.
        /// Search Keywords
        /// </summary>
        /// <value>
        /// The key words.
        /// </value>
        String KeyWords { get; set; }
        
        /// <summary>
        /// Gets or sets the CSS.
        /// Optional CSS 2.1 Stylesheet for the document
        /// </summary>
        /// <value>
        /// The CSS.
        /// </value>
        String CSS { get; set; }
       
        /// <summary>
        /// Gets or sets the content of the HTML.
        /// </summary>
        /// <value>
        /// The content of the HTML.
        /// </value>
        String HTMLContent { get; set; }
       
        /// <summary>
        /// The PDF in a Byte array
        /// </summary>
        Byte[] PDF { get; }
        
    }
}
