﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using CValenzuela.Common;


namespace CValenzuela.Web.CSSParserDemo
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            this.lnkParseCSSFile.Click += new EventHandler(lnkParseCSSFile_Click);
        }

        void lnkParseCSSFile_Click(object sender, EventArgs e)
        {
            CSSParser parser = new CSSParser();
            parser.ReadCSSFile(Server.MapPath("~/CSSParserStyle.css"));
            //Display the Original CSS with some formating for the web
            this.divOriginalCSS.InnerHtml = parser.StyleSheet.FixLineBreakForWeb().FixTabsForWeb().FixSpaceForWeb();
            //Display the parsed CSS
            this.divParsedCSS.InnerHtml = parser.ToString();
            this.spnOriginalCSSLength.InnerText = parser.StyleSheet.Length.ToString();
            this.spnParsedCSSLength.InnerText = this.divParsedCSS.InnerHtml.Length.ToString();
        }
    }

}