 <?php
  /**********************************************
   ** awfDialog Class 1.2 (PHP programming object)                     
   **********************************************
    Generate dynamic, AJAX enabled, wizard-style dialog
    boxes such as those found in standard desktop
    applications.
                   
    Copyright (C) 2008 A.W. Ford, flooredmusic.nospam AT gmail.com
   
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU General Public License as published by the Free Software Foundation; either version 2 of
    the License, or any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program; if not,
    write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
		
    A copy of the GNU License is located at awfDialog/docs/license.php
   ***********************************************
   
   Complete documentation can be found in the awfDialog/docs folder.
   Working samples can be found in the awfDialog/examples folder.
      
   ***********************************************
   Dependencies:
    - GD library for dynamic gradient support
	- class.gradient_image.php by Fabricio Biazzotto
   
   ***********************************************/
?>


<?php

/*************************************
    Define constants
*************************************/
define ('VERSION', 'awfDialog Class 1.2');

define ('ICON_NONE', 0);
define ('ICON_CSS', 1);
define ('ICON_INFO', 2);
define ('ICON_HELP', 3);
define ('ICON_WARN', 4);
define ('ICON_ERROR', 5);
define ('ICON_WIZARD', 6);
define ('ICON_CONFIG',7);
define ('ICON_CHAT',8);
define ('ICON_SEARCH',9);
define ('ICON_USERS',10);
define ('ICON_USER',11);
define ('ICON_MAIL',12);
define ('ICON_DOWNLOAD',13);
define ('ICON_UPLOAD',14);
define ('ICON_KEY',15);
define ('ICON_LOCKED',16);
define ('ICON_UNLOCKED',17);
define ('ICON_MONEY',18);

define ('ICON_SIZE_SM',0);
define ('ICON_SIZE_LG',1);

define ('GRADIENT_H', 0);
define ('GRADIENT_V',1);

define ('EFFECT_NONE',0);
define ('EFFECT_CURVED',1);
define ('EFFECT_LIGHTBOX',2);

define ('SCROLL_NONE',0);
define ('SCROLL_H',1);
define ('SCROLL_V',2);

define ('BODY_TOP',0);
define ('BODY_MIDDLE',1);
define ('BODY_BOTTOM',2);
define ('BODY_LEFT',3);
define ('BODY_CENTER',4);
define ('BODY_RIGHT',5);

class awfDialog {
    
    /*************************************
        Variables
    *************************************/
    var $dialogID;    // String. Unique identifier for the dialog box to be rendered. Useful, for instance, when creating sequential dialogs as in an application wizard and you need to know your current position in the sequence
    var $dVersion;    //String. Class version info.
    var $dTitle;      //String. Text to display in the title bar
    var $dIconValue;  // String. Path and file name to use if $dIconType is set to ICON_CSS in order to use custom icons
    var $dIconType;   //Integer. Accepts only one of the ICON constants defined above
    var $dUseGradient; //Boolean. Whether or not to use a dynamicly generated gradient in the title bar
    var $dGradientDirection; //Integer. Is the gradient horizontal or vertical, accepts only GRADIENT constants defined above
    var $dTitleGrad1; //String. If $dUseGradient is true, color value for upper or left position
    var $dTitleGrad2; //String. If $dUseGradient is true, color value for lower or right position
    var $dUseWizImg;  //Boolean. Use a wizard-style image on the left side of the dialog
    var $dWizImage;   //String. Relative path to image to use if $dUseWizImg true
    var $dProcessArray; //String Array. Internal class debug event log.
    var $dOutput;     //HTML/browser output to place inside the dialog box
    var $dScrollType;   //If true display inline scrollbar withing the dialog box
    var $dWidth;
    var $dModal;
    var $dBodyVAlign;
    var $dBodyHAlign;
    var $dIconSize;
    var $dTitleBGColor;
    var $dWizBGColor;
    var $dBodyBGColor;
    var $imagePHPBase;
    var $imagePHPURL;
    var $dWizMode=false;
    var $dAjaxPrev;
    var $dAjaxCancel;
    var $dAjaxNext;
    var $dAjaxHelp;
    var $dImagePath;
    var $dCSSArray;   //1.2
    var $dCSSOut;     //1.2
    var $dJavascriptSet;  //1.2
    var $dShowHelp;   //1.2
    var $dHelpOutput; //1.2
    
    /*************************************
    *                     Public Methods                 *
    *************************************/
    
    function awfDialog ($id, $title='', $message='', $icotype=ICON_NONE, $modal='',$width=0) {
        $this->dVersion=VERSION;
        $this->dTitle=$title;
        $this->dialogID = $id;
        $this->dOutput=$message;
        $this->dIconType=$icotype;
        if ($modal==''){
          $this->dModal=false;
        } else {
          $this->dModal=$modal;  
        }
        
        if ($width !==0) $this->dWidth=$width;
        $this->dIconValue='';
        $this->dUseGradient=false;
        $this->dTitleGrad1='';
        $this->dTitleGrad2='';
        $this->dUseWizImg=false;
        $this->dWizImage='';
        $this->dScrollType=SCROLL_NONE;
        $this->dTitleBGColor='#999999';
        $this->dWizBGColor='#aaaaaa';
        $this->dBodyBGColor='#ffffff';
        $this->dProcessArray= array();
        $this->dIconSize=ICON_SIZE_LG;
        $this->dGradientDirection=GRADIENT_V;
        $this->_debug("Instantiate class(VERSION: ".$this->dVersion." | TITLE: ".$this->dTitle." | ICON: ".$icotype." | MODAL: ".$this->dModal." | WIDTH: ".$width.")");
        $this->dJavascriptSet=false;
        $this->dCSSOut="";
        $this->dHelpOutput="";
        $this->dShowHelp=false;
        $this->dAjaxHelp="";
    }

// TODO: Put all the public functions in alpha order to make them easier to find. 
    
    public function UseHelp($value, $script=""){
      if ($value == true){
        $this->dUseHelp=true;
        if (strlen($script)>0) $this->dAjaxHelp=$script; 
      } else {
          $this->dUseHelp=false;
          $this->dAjaxHelp=false;
      }
      $this->_debug("Use Help Set: ".$value.", ".$script);
    }
    
    public function SetAjaxHelp($script){
      if (strlen($script)>0) $this->dAjaxHelp=$script;
      $this->_debug("Ajax Help Set: ".$script);
    }
    
    public function AddHelp($string){
      $this->dHelpOutput.=$string;
      $this->_debug("Add Help");
    }
    
    public function SetImagePath($path){
      if ($this->dImagePath !== ''){
        $this->dImagePath=$path;
      } else {
        $this->dImagePath="awfDialog/lib/images/";
      }
      $this->_debug('Set Image Path: '.$this->dImagePath);
    }
    
    public function SetAjaxPrev($scriptname){
        if (strlen($scriptname)>0) $this->dAjaxPrev=$scriptname;
        $this->_debug("Set Ajax Previous Button Event: ".$scriptname);
    }
    
    public function SetAjaxCancel($scriptname){
        if (strlen($scriptname)>0) $this->dAjaxCancel=$scriptname;
        $this->_debug("Set Ajax Cancel Button Event: ".$scriptname);
    }

    public function SetAjaxNext($scriptname){
        if (strlen($scriptname)>0) $this->dAjaxNext=$scriptname;
        $this->_debug("Set Ajax Next Button Event: ".$scriptname);
    }
    
    function SetWizMode($mode){
        if ($mode=='true') {
            $this->dWizMode=true;
        } else {
            $this->dWizMode=false;
            $this->dAjaxCancel='';
            $this->dAjaxNext='';
            $this->dAjaxPrev='';
            $this->dUseWizImg=false;
        }
        $this->_debug("Set Wizard Mode: ".$mode);
    }
    
    public function SetTitleBGColor($hex){
        if ($hex) $this->dTitleBGColor=$hex;
        $this->_debug('Set Title BGColor: '.$hex);
    }
    
    public function SetWizBGColor($hex){
        if ($hex) $this->dWizBGColor=$hex;
        $this->_debug('Set Wiziard Div BGColor: '.$hex);
    }
    
    public function SetBodyBGColor($hex){
        if ($hex) $this->dBodyBGColor=$hex;
        $this->_debug('Set Body BGColor: '.$hex);
    }
    
    public function SetID($id) {
        $this->_debug('Old Dialog ID: '.$this->dialogID);
        if ($id) $this->dialogID=$id;
        $this->_debug('New Dialog ID: '.$$id);
    }
    
    public function SetVAlign($value){
        if ($value) $this->dBodyVAlign=$value;
        $this->_debug("Set BodyVAlign: ".$value);
    }

    public function SetHAlign($value){
        if ($value) $this->dBodyHAlign=$value;
        $this->_debug("Set BodyHAlign: ".$value);
    }

    
    public function SetTitle($title){
        if ($title) $this->dTitle=$title;
        $this->_debug("Set Title: ".$title);
    }

    public function SetIconType($icon){
        if ($icon) $this->dIconType=$icon;
        $this->_debug("Set Icon Type: ".$icon);
    }

    public function SetIcon($type,$value=''){
        if ($type) $this->dIconType=$type;
        if ($type==ICON_CSS) $this->dIconValue=$value;
        $this->_debug("Set Icon - TYPE: ".$type." | VALUE: ".$value);
    }

    public function SetGradient($color1,$color2){
        if ($color1) $this->dTitleGrad1=$color1;
        if ($color2) $this->dTitleGrad2=$color2;
        $this->dUseGradient=true;
        $this->_debug("Set Gradient - COLOR1: ".$color1." | COLOR2: ".$color2);
    }

    public function SetGradientDirection($direction){
      if ($direction==GRADIENT_V) {
        $this->dGradientDirection=$direction;
      } else {
        $this->dGradientDirection=GRADIENT_H;
      }
      $this->_debug("Set Gradient Direction: ".$this->dGradientDirection);
    }

    public function SetImagePHPURL($url){
        if ($url) $this->imagePHPBase=$url;
    }

    public function EnableWizImage() {
        $this->dUseWizImg=true;
        $this->_debug("Wizard Image Enabled");
    }

    public function DisableWizImage() {
        $this->dUseWizImg=false;
        $this->_debug("Wizard Mode Disabled");
    }
    
    public function SetWizImage($path) {
        if ($path) $this->dWizImage=$path;
        $this->_debug("Set Wizard Image: ".$path);
    }
    
    public function SetScrollType($scroll){
        if ($scroll) $this->dScrollType=$scroll;
        $this->_debug("Set Scroll: ".$scroll);
    }

    public function AddOutput($data){
        if ($data) $this->dOutput.=$data;
        $this->_debug("Append Output");
    }
   
    public function SetModal($value){
        if ($value) $this->dModal=$value;
        $this->_debug("Set Modal: ".$this->dModal);
    }
    
    public function Clear(){
        $this->dOutput='';
        $this->dHelpOutput='';
        $this->_debug("Delete Help & Output Buffers");
    }

    public function Render() {
        $final = $this->_prerender();
        $final = $final.$this->dOutput;
        $final = $final.$this->_postrender();
        echo $final;
        $this->_debug("Render Output");
    }
    public function DebugDump(){
        $this->_debug("Debug Dump");
        echo '<pre>';
        print_r($this->dProcessArray);
        echo '</pre>';
    }

    public function SetWidth($width){
        if ($width) $this->dWidth=$width;
        $this->_debug("Set Width: ".$width);
    }
    
    public function SetIconSize($size){
        if ($size==ICON_SIZE_LG) $this->dIconSize=ICON_SIZE_LG;
        if ($size==ICON_SIZE_SM) $this->dIconSize=ICON_SIZE_SM;
        $this->_debug("Set Icon Size: ".$size);
    }
    
    public function SetCSS($element, $css){
      if (strlen($element) > 0 && strlen($css) > 0) {
        $this->dCSSArray[$element] = $css;
      } else {
		$this->_debug("SetCSS FAILED: One or more arguments missing ".$element." { ".$css." }");
	  }
    }



    
    
    /*************************************
        Private Methods
    *************************************/
    
    private function _prerender(){
        $this->_debug("Pre-Render Start");
        
        //Establish vertical alignment
        switch ($this->dBodyVAlign) {
            case BODY_TOP:
                $strValign=" valign='top' ";
                break;
            case BODY_MIDDLE:
                $strValign=" valign='absmid' ";
                break;
            case BODY_BOTTOM:
                $strValign=" valign='bottom' ";
                break;
        }
        //Establish horizontal alignment
        switch ($this->dBodyHAlign) {
            case BODY_LEFT:
                $strHalign=" align='left' ";
                break;
            case BODY_CENTER:
                $strHalign=" align='center' ";
                break;
            case BODY_RIGHT:
                $strHalign=" align='right' ";
                break;
        }
        $cols=1;                //default, not wizard style
        
        //Width
        if ($this->dWidth =='') {
            $strwidth=''; 
        } else {
            $strwidth="width='$this->dWidth'";
        }
        //check if exit btn javascript already written, if not write it
          if ($this->dJavascriptSet == false){
            ?>
              <!--Javascript used by awfDialog class for the exit button-->
              <script>function toggleLayer( whichLayer )
              {
                var elem, vis;
                if( document.getElementById ) // this is the way the standards work
                  elem = document.getElementById( whichLayer );
                else if( document.all ) // this is the way old msie versions work
                    elem = document.all[whichLayer];
                else if( document.layers ) // this is the way nn4 works
                  elem = document.layers[whichLayer];
                vis = elem.style;
                // if the style.display value is blank we try to figure it out here
                if(vis.display==''&&elem.offsetWidth!=undefined&&elem.offsetHeight!=undefined)
                  vis.display = (elem.offsetWidth!=0&&elem.offsetHeight!=0)?'block':'none';
                vis.display = (vis.display==''||vis.display=='block')?'none':'block';
              }
              </script>
            <?php
            $this->dJavascriptSet=true;
          }
        $this->_doCSS();
        $pre.="\n<style>".$this->dCSSOut."\n</style>";

        //start actual dialog output
        $pre .= "<div id='".$this->dialogID."MasterDiv' width='$this->dWidth' >\n";
        $pre .= "<table cellpadding=0 cellspacing=0 border=0 ".$strwidth." class='".$this->dialogID;
        $pre .= "Table' style='border:1px solid #000;'>\n";
        if ($this->dUseWizImg == true)  $cols=2;
        $this->_buildGradient();
        $pre .= "<tr>\n<td background='".$this->imagePHPURL."' bgcolor='".$this->dTitleBGColor;
        $pre .= "' align=center valign=absmid id='".$this->dialogID."Title' colspan=".$cols;
        $pre .= " NOWRAP style='border-bottom:1px solid #000;padding:1px'>\n";
        $pre .= $this->_buildIcon().$this->_buildControlBox().$this->dTitle."</td>\n</tr>\n<tr>\n";
        if ($this->dUseWizImg == true) {
            if ($this->dWizImage==''){
                $pre .= "<td id='".$this->dialogID."WizardPane' bgcolor='".$this->dWizBGColor;
                $pre .="' valign='top' style='border-right:1px solid #000;'>\n<img src='".$this->dImagePath;
                $pre .= "wizDefault.jpg'></td>\n";
            } else {
            $pre .= "<td id='".$this->dialogID."WizardPane' bgcolor='".$this->dWizBGColor;
            $pre .= "' valign='top' style='border-right:1px solid #000;'>\n<img src='".$this->dWizImage;
            $pre .= "'></td>\n";
            }
        }
        $pre .= "<td id='".$this->dialogID."BodyPane' bgcolor='".$this->dBodyBGColor."' width='100%'".$strHalign.$strValign.">\n";
        if ($this->dUseHelp==true){
          $pre .= "<div id='".$this->dialogID."HelpPane' style='display:none;'>".$this->dHelpOutput."</div>";
        }
        $this->_debug("Pre-Render Complete");
        return $pre;
    }
    
    private function _postrender(){
        $this->_debug("Post-Render Start");
        $post = $this->_buildAjaxButtons()."</td></tr></table></div>";
        $this->_debug("Post-Render Complete");
        return $post;
    }
    
    private function _buildIcon(){
        $path='';
        $size='';
        switch($this->dIconType) {
            case ICON_CSS:
				if (strlen($this->dIconValue) > 0){
				  $path=$this->dIconValue;
				} else {
				  $path='';
				}
                break;
            case ICON_HELP:
                $path=$this->dImagePath.'icoHelp.gif';
                break;
            case ICON_INFO:
                $path=$this->dImagePath.'icoInfo.gif';
                break;
            case ICON_CONFIG:
                $path=$this->dImagePath.'icoConfig.gif';
                break;
            case ICON_CHAT:
                $path=$this->dImagePath.'icoChat.gif';
                break;
            case ICON_SEARCH:
                $path=$this->dImagePath.'icoSearch.gif';
                break;
            case ICON_ERROR:
                $path=$this->dImagePath.'icoError.gif';
                break;
            case ICON_USERS:
                $path=$this->dImagePath.'icoUsers.gif';
                break;
            case ICON_USER:
                $path=$this->dImagePath.'icoUser.gif';
                break;
            case ICON_WIZARD:
                $path=$this->dImagePath.'icoWizard.gif';
                break;
            case ICON_WARN:
                $path=$this->dImagePath.'icoWarn.gif';
                break;
            case ICON_MAIL:
                $path=$this->dImagePath.'icoMail.gif';
                break;
            case ICON_DOWNLOAD:
                $path=$this->dImagePath.'icoDownload.gif';
                break;
            case ICON_UPLOAD:
                $path=$this->dImagePath.'icoUpload.gif';
                break;
            case ICON_KEY;
                $path=$this->dImagePath.'icoKey.gif';
                break;
            case ICON_LOCKED:
                $path=$this->dImagePath.'icoLocked.gif';
                break;
            case ICON_UNLOCKED:
                $path=$this->dImagePath.'icoUnlocked.gif';
                break;
            case ICON_MONEY:
                $path=$this->dImagePath.'icoMoney.gif';
                break;
            default:
                return '';
                exit;
        }
		if ($path=='') return '';
        if ($this->dIconSize==ICON_SIZE_SM) $size=' height=20 width=20 ';
        $imgStr="<div style='float:left'><img src='".$path."' id='".$this->dialogID."Icon'".$size."></div>";
        $this->_debug("--Build Icon: ".$path);
        return $imgStr;
    }

    private function _buildControlBox(){
      $imgStr="<div id='".$this->dialogID."ControlBox' style='float:right' style='display:inline;'>";
      //Help Button
      if ($this->dUseHelp==true){
        if (strlen($this->dAjaxHelp)>0) {
          $hlpScript = " onClick=\"".$this->dAjaxHelp."\"" ;
          $this->_debug("--Ajax Help Button Built: ".$this->dAjaxHelp);
        } else {
          $hlpScript = " onClick=\"toggleLayer('".$this->dialogID."HelpPane')\"";
          $this->_debug("--Default Help Button Built");
        }
        $imgStr.="<div id='".$this->dialogID."AjaxHelp' style='display:inline;cursor:pointer;'".$hlpScript.">";
        $imgStr.="<img src='".$this->dImagePath."help.gif'>&nbsp;</div>";
      } else {
        $this->_debug("--Help Disabled");
      }
      //Exit Button
      if ($this->dModal==false) {
        $imgStr.="<div id='".$this->dialogID."AjaxExit' style='display:inline;'><img src='".$this->dImagePath."exit.gif' ";
        $imgStr.="onClick=\"toggleLayer('".$this->dialogID."MasterDiv')\" style=\"cursor:pointer;\" ";
        $imgStr.="valign=top></div>";
      } 
      $imgStr.="</div>";
      return $imgStr;
    }
    
    private function _debug($step){
        if ($step) array_push($this->dProcessArray, $step.', ');
    }


    private function _buildGradient(){
        $url=$this->imagePHPBase;
        $url=$url."?from=".$this->dTitleGrad1;
        $url=$url."&to=".$this->dTitleGrad2;
        $url=$url."&w=".$this->dWidth;
        if ($this->dIconSize==ICON_SIZE_SM){
            $url=$url."&h=23";
        } else {
            $url=$url."&h=35";
        }
        if($this->dGradientDirection==GRADIENT_H){
          $url=$url."&d=true";
        } else {
          $url=$url."&d=false";
        }
        $this->imagePHPURL=$url;
        $this->_debug("--Gradient built: ".$url);
    }

    private function _buildAjaxButtons(){
        $checksum=0;
        if ($this->dWizMode==true){
            $ajax="<div id='".$this->dialogID."WizButtons' style='margin:10'><center><table width='100%'><tr><td width='33%'>";
            if (strlen($this->dAjaxPrev)>0){
                $ajax=$ajax."<div id='".$this->dialogID."AjaxPrev' style='float:left;cursor:pointer;'>";
                $ajax=$ajax."<img src='".$this->dImagePath."wizPrev.gif' onClick=\"javascript:".$this->dAjaxPrev."\" title='Previous'></div>";
                $checksum=$checksum+1;
            }
			$ajax.="</td><td align='center'  width='33%'>";
            if (strlen($this->dAjaxCancel)>0){
                $ajax=$ajax."<div id='".$this->dialogID."AjaxCancel' style='cursor:pointer;width:30px' >";
                $ajax=$ajax."<img src='".$this->dImagePath."wizCancel.gif' onClick=\"javascript:".$this->dAjaxCancel."\" title='Cancel'></div>";
                $checksum=$checksum+2;
            }
			$ajax.="</td><td  width='33%'>";
            if (strlen($this->dAjaxNext)>0){
                $ajax=$ajax."<div id='".$this->dialogID."AjaxNext' style='float:right;cursor:pointer;' >";
                $ajax=$ajax."<img src='".$this->dImagePath."wizNext.gif' onClick=\"javascript:".$this->dAjaxNext."\" title='Next'></div>";
                $checksum=$checksum+4;
            }
            $ajax=$ajax."</td></tr></table></center></div>";
            if ($checksum==0){
                $this->_debug('ERROR: wiz mode set but no ajax buttons defined');
            } else {
                $this->_debug("ajax button created: ".$checksum);
            }
            return $ajax;
        }
    }

    private function _doCSS(){
      $i=count($this->dCSSArray);
      $j=0;
      $this->_debug("--CSSArray count = ".$i);
	  if ($i >0){
		foreach ($this->dCSSArray as $key => $value){
		  $this->_debug("--".$j." - CSS ".$key.": ".$value);
		  $this->dCSSOut.="#".$this->dialogID.$key." {\n ".$value."\n}\n";
		  $j++;
		}
      }
    }


// End Class
}



















?>