<?php 
class fileSettings {
	private $error = array();
	private $log = array();
	private $chmod = 0777;
	private $type = NULL;
	// konstruktor objektu
	public function __construct($path, $chmod) {
		$this->addLog('<strong style="color:green;">Starting with CHMOD on '.$path.' with chmod 0777</strong>');
		if (is_file($path)) {
			$this->type = 'file';
			$this->setChmodFile($path);
		}
		elseif (is_dir($path)) {
			$this->type = 'file';
			if (@chmod($path, $this->chmod)) $this->addLog('<strong>Chmod for home folder is setted on '.$path.'.</strong>');
			else {
				$this->addLog('<strong>Cant set chmod on defaul folder '.$path.'.</strong>');
				$this->addError('Cant set chmod on defaul folder '.$path.'.');
			}
			$this->setChmodDir($path);
		}
		else {
			$this->addError('Path '.$path.' is wrong.');
			$this->addLog('Path '.$path.' is wrong.');
		}
		$this->addLog('<strong style="color:green;">End of settings atributes on path '.$path.'.</strong>');
	}
	// nastaví práva souboru
	private function setChmodFile($path) {
		if (@chmod($path, 0777)) $this->addLog('Chmod is setted on '.$path.'.');
		else {
			$this->addLog('<strong style="color:red;">Cant set chmod on '.$path.'.</strong>');
			$this->addError('Cant set chmod on '.$path.'.');
		}
		
	}
	// nastaví práva adresáři
	private function setChmodDir($path) {
		$path = trim($path, '/');
		$path = '/'.$path.'/';
		$dir = opendir($path); 
		$this->addLog('<strong>Opening '.$path.' folder.</strong>');
		while (false!==($file = readdir($dir))) { 
			if ($file != "." && $file != "..") { 
				if (is_dir($path.''.$file)) {
					$this->setChmodFile($path.''.$file);
					self::setChmodDir($path.''.$file);
				}
				else {
					$this->setChmodFile($path.''.$file);
				}
			} 
		}
		closedir($dir); 
	}
	// přidá jeden řádek do logu
	private function addLog($message) {
		$this->log[] = $message;
	}
	// přidá jednu chybu
	private function addError($error, $type=0) {
		$this->error[$type][] = $error;
	}
	// vrátí případné chyby
	public function getErrors() {
		return $this->error;
	}
	// vrátí případné chyby
	public function getLog() {
		return $this->log;
	}

}

?>