<?php

/*========================*\

 * cache_TS
 * Written by: AS
 * Mialto: as@twoja-strona.net
 * Date: 2007-08-23
 * Cache: multiSystem cache SQL and PHP code
 * Version: 1 
 * Licencia: Lesser General Public License (LGPL)   
 * 
 * Copyright (C) 2007 Jacek Wloka
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.  

\*========================*/

class cache_TS {


 /**************************\
 
  @ $query {string} unique id, query sql
  @ $time {int} the time in seconds of duration
  @ $file {string} md5 cached file
  @ $switch {bool} 1 - not cached / 0 - cached

 \**************************/
   var $query;
   var $time;
   var $file;
   var $switch;


 /**************************\
   
   function check_cache
   ( 
     query -> $q,
     time -> $t,
     dir -> cache folder     
   )

 \**************************/
 function check_cache ($q, $t=300, $dir="./cache")
 {
     if ($q == '') 
     {
         $this->switch = 1;  
         return 1;
     }

     $this->time = $t;
     $this->query = $q;
     $this->file = $dir.'/'.md5($this->query).'.cache'; 

     if ((time()-@filemtime($this->file)) > $this->time) 
     { 
         $this->switch = 1;
         return 1;  
     }
      else 
     {      
         $this->switch = 0;         
         return 0;  
     }
 }


 /**************************\
   
   function start_cache
   ( switch -> true or false )

 \**************************/ 
 function start_cache ()
 {
     if ($this->switch) {@ob_start();}       
 }


 /**************************\
   
   function end_cache
   ( switch -> true or false )

 \**************************/ 
 function end_cache ()
 {
     if ($this->switch)
     {
         $contents = @ob_get_contents();
         @ob_end_clean();
         if ($f = @fopen($this->file, "wb"))
         {
             @fwrite($f, $contents);
             @fclose($f);
         }
         echo $contents;
     }
 }


 /**************************\
   
   function contents_cache
   ( readfile cache )

 \**************************/ 
 function contents_cache ()
 {
     @readfile($this->file);
 }


 /**************************\

   clean up the folder of cache  

   function emptying_cache
   ( 
     dir -> cache folder 
     DeleteMe -> delete folder  1 - yes or 0 - no
   )

 \**************************/ 
 function emptying_cache ($dir, $DeleteMe=0)
 {
    if (!$dh = @opendir($dir)) {return false;}
    while (false !== ($obj = @readdir($dh)))
    {
        if ($obj == '.' || $obj == '..' || $obj == 'index.html')
        {
            continue;
        }
         else 
        {
            if (!@unlink($dir.'/'.$obj)) {SureRemoveDir($dir.'/'.$obj, true);}
        }  
        
    }

    if ($DeleteMe)
    {
        @closedir($dh);
        @rmdir($dir);
    }
 }

}

?>