<?php
/***********************************************************************
* Batikon AJAX ile Update Aparatı                                      *
************************************************************************
* Tüm hakları Batikon grubuna aittir.İzinsiz bir şekilde çoğaltılamaz, *
* geliştirilemez ya da kullanılamaz.                                   *
************************************************************************
* Batikon                                                              *
* www.batikon.net                                                      *
***********************************************************************/


class update {
	/**
	 * Update edilecek divi belirten değişkeni tanımlıyoruz.
	 *
	 * @var string
	 */
	public $divID;
	
	/**
	 * Kaç saniyede sayfayı yenileyeceğini belirten değişkeni tanımlıyoruz.
	 *
	 * @var int
	 */
	public $timeOut;
	
	/**
	 * Update işlemi olurken hangi sayfanın kullanılacağını belirten değişkeni tanımlıyoruz.
	 *
	 * @var int
	 */
	public $URL;
	
	/**
	 * Hatayı  belirten değişkeni tanımlıyoruz.
	 *
	 * @var string
	 */
	 public $errorStr;
	
	/**
	 * Mootools adresini belirten değişkeni tanımlıyoruz.
	 *
	 * @var string
	 */
	 public $mtURL = "bupdate/mootools-release-1.11.js";
	 
	/**
	 * Uyarı mesajları için gerekli olan stil
	 *
	 * @param none
	 */
	 public function css() {
		echo '
		<style>
			.hata {
				background: #FFFF99;
				border: 2px solid #797979;
				padding-left: 3px;
				padding-top: 3px;
				padding-bottom: 3px;
				font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
				font-size: 12px;
			}
		</style>';	 
	}
	
	/**
	 * Hata vermeyi sağlayan fonksiyon
	 *
	 * @param none
	 */
	 public function error($errorStr) {
		 $this->errorStr = $errorStr;
		 self::css();
		 echo '<div class="hata"><strong>Batikon Update ERROR:</strong> '.$this->errorStr.'</div>'; 
	 }
	
	/**
	 * Mootools dosyasının bulunup bulunmadığını kontrol ediyoruz.
	 *
	 * @param none
	 */
	 public function mootoolsCheck() {
		if(!file_exists($this->mtURL)) {
			$this->error("Mootools dosyası bulunamadı.");
			exit;
		}	 
	}
	
	/**
	 * Javascript dosyasını içeri almak için gerekli olan fonksiyon.
	 *
	 * @param none
	 */
	 public function importMT() {
		 echo '<script type="text/javascript" src="'.$this->mtURL.'"></script>';
	}
	
	/**
	 * İşlemi yapacak olan javascript için gerekli fonksiyon.
	 *
	 * @param none
	 */
	 public function runJS() {
		echo '
		<script>
			window.onload = function() {
				check();
			}
			
			function check() {
				new Ajax("'.$this->URL.'", {
					update: $("'.$this->divID.'")
				}).request();
				setTimeout("check()",'.$this->timeOut.');
			}
		</script>';
	}
	
	/**
	 * Update fonksiyonumuz tanımlıyoruz.
	 *
	 * @param divID,timeOut
	 */
	public function __construct($divID,$URL="",$timeOut=600) {
		self::mootoolsCheck();
		$this->divID = $divID;
		$this->timeOut = $timeOut;
		$this->URL = $URL;
		if(empty($this->timeOut)) {
			$this->timeOut = 600;
		}
		if(empty($this->URL)) {
			$this->error("Lütfen Update işlemi için kullanılacak sayfayı belirtin.");
			exit;
		}
		if(empty($this->divID)) {
			$this->error("Lütfen bir div ID belirtiniz.");
			exit;
		}
		# Mootools javascriptini sayfaya çağıracak fonksyion.
		self::importMT();
		
		# İşlemi yapacak javascript kodunu derleyen fonksyion.
		self::runJS();
	}
}
?>