<?php


require_once './class.imagegradient.php';

$imagetype='jpg';
//$imagetype='png';

$gradfl = './gradient.'.$imagetype;

$im = imagecreatetruecolor(640, 480);
imagealphablending($im, true);
imagesavealpha($im , false );

if( function_exists('imageantialias')) imageantialias( $im, true );
	
$bgColorSilver = imagecolorallocate( $im, 127, 127, 127 );
//$bgColorSilverLight = imagecolorallocate( $im, 180, 180, 180 );

imagefill($im, 0,0, $bgColorSilver);

$grad = new imagegradient( $im );


$startcol=array(30,30,30);
$endcol=array(200,200,200);

// half right, gray background blocks
$grad->left2right($startcol, $endcol, 320,0,320,240,false);
$grad->left2right($startcol, $endcol, 320,240,320,240,true);

$startcol=array(255,127,0);
$endcol=array(200,200,0);

// half left, red-green diagonal, overlay with alpha
	$grad->diag_tr2bl(array(255,40,10,127),array(200,220,60,90),0,0,320,480,true);
	//right quarter/3, reg-green diagonal, overlay with alpha
	$grad->diag_tr2bl(array(255,40,10,127),array(200,220,60,90),400,0,60,480,true);
	$grad->diag_tr2bl(array(255,40,10,127),array(200,220,60,90),0,210,640,120,true);
	$grad->diag_tr2bl(array(255,40,10,127),array(200,220,60,90),430,0,160,480,true);
// half left, red-green diagonal, overlay opaque
	// $grad->diag_tr2bl(array(255,40,10),array(200,220,60),0,0,320,480,true);


/*
//2 * opaque-red---green
$grad->top2bottom($startcol, $endcol, 10,10,40,40,false);
$grad->top2bottom($startcol, $endcol, 60,10,40,40,true);

// 2 * alpha///gray
$startcol=array(30,30,30,70);
$endcol=array(200,200,200,40);
$grad->diag_tl2br($startcol,$endcol,10,60,100,100,false);
$grad->diag_tr2bl($startcol,$endcol,10,170,100,100,true);



//$grad->gradient_sphere(array(255,50,50,90),array(255,0,100,127),319,239,250,false);
//$grad->gradient_sphere(array(255,50,50,90),array(255,0,100,127),319,239,250,true);

*/
// sphere dark & light in side
$grad->gradient_sphere(array(0,0,0,0),array(255,255,200,127),490,330,250,false);

$grad->gradient_sphere(array(0,0,0),array(255,255,200),230,330,250,false);

/*
// light stars
	// big one
$grad->gradient_sphere(array(255,255,200,127),array(255,255,255,0),319,239,250,false);
	// small ones
$grad->gradient_sphere(array(255,255,200,127),array(255,255,255,0),200,250,100,false);
$grad->gradient_sphere(array(255,255,200,127),array(255,255,255,0),250,350,50,false);
$grad->gradient_sphere(array(255,255,200,127),array(255,255,255,0),270,270,50,false);

// $startcol=array(255,255,255 ,127);//centre of corners
// $endcol=array(255,255,255, 0);
// 
// $grad->gradient_cor($startcol, $endcol, 220,10,100,'tl' );
// 				$grad->gradient_cor($startcol, $endcol, 330,10,100,'tr' );



$startcol=array(255,255,255, 0); 
$endcol=array(255,255,255 ,127);//centre of corners


// $grad->gradient_cor($startcol, $endcol, 220,120,100,'bl' );
// $grad->gradient_cor($startcol, $endcol, 330,120,100,'br' );
				
//small corners
$grad->gradient_cor($startcol, $endcol, 420,10,30,'tl' );
$grad->gradient_cor($startcol, $endcol, 455,10,30,'tr' );
$grad->gradient_cor($startcol, $endcol, 420,45,30,'bl' );
$grad->gradient_cor($startcol, $endcol, 455,45,30,'br' );
				
*/

//header('Content-Disposition: attachment; filename=gradinets.png');

if($imagetype=='png')
	imagepng( $im, $gradfl );
elseif($imagetype=='jpg')
	imagejpeg( $im, $gradfl, 100 );

//header( 'Content-type: image/png' );
//header( 'Content-Length: ' . filesize( $gradfl ) );
//strtotime( gmdate( "l, d-F-Y H:i:s", time() ) )

header( 'Content-Type: text/html' );
header( 'Cache-Control: no-cache' );
header( 'Pragma: no-cache' );

echo "<"."?xml version=\"1.0\" encoding=\"iso-8859-1\"?".">
<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">
<html><head>
<title>Testing class.imagegradient.php</title>
</head>
<body bgColor=\"#FFFFFF\" >
<center>
<h1>Testing class.imagegradient.php</h1>
<p>Local time: " .date( "l, d-F-Y H:i:s", time() ). ", (GMD: " .gmdate( "H:i:s", time() ). ") </p>
<img src=\"$gradfl\" />
</center>
</body></html>";

?>
