<?php

require_once './class.coverflow.php';

$width = 600;
$height =  400;

set_time_limit( 180 );


$coversArray = array(
	//             imageSRC                 imageTITLE                              URL               
	
	
	array(    './covers/coverflow10.jpg',     ' ',              './covers/coverflow10.jpg'    ) ,
	array(    './covers/coverflow11.jpg',     ' ',              './covers/coverflow11.jpg'    ) ,
	array(    './covers/coverflow20.jpg',     ' ',             './covers/coverflow20.jpg'    ) ,
	array(    './covers/coverflow30.jpg',     ' ',           './covers/coverflow30.jpg'    ) ,
	array(    './covers/coverflow31.jpg',     ' ',           './covers/coverflow31.jpg'    ) ,
	array(    './covers/cfp_0.jpg',      ' ',         './covers/cfp_0.jpg'          ) ,
 	array(    './covers/cfp_1A.jpg',     ' ',         './covers/cfp_1A.jpg'         ) ,
  
	array(    './covers/cfp_1B.jpg',     ' ',       './covers/cfp_1B.jpg'         ) ,
    
	array(    './covers/noges.jpg',    ' ',        './covers/noges.jpg'   ) ,
    array(    './covers/lill.jpg',     ' ',  './covers/lill.jpg'    ) ,
	array(    './covers/saun.jpg',     ' ',                 './covers/saun.jpg'    ) ,
	array(    './covers/tamm.jpg',     ' ',                   './covers/tamm.jpg'    ) 
	/**/
	 );

$countcoversArray = count($coversArray);



if( isset($_GET['cfp']) ) $centered = (int) $_GET['cfp']; 
else $centered = 0;
if( isset($_GET['cft']) ) $cftype = $_GET['cft']; //coverFlow, gameCards, topSites
else $cftype = 'coverFlow';


if( $centered < 0 ) $centered = 0;
elseif( $centered < $countcoversArray );
else $centered = $countcoversArray-1;



    switch($cftype){
        case 'coverFlow': $imageCachefileSrc = './cache/cfp_'. $centered .'.jpg';$imageCachefileHtm = './cache/cfp_'. $centered .'.htm';break;
        case 'gameCards': $imageCachefileSrc = './cache/gcp_'. $centered .'.jpg';$imageCachefileHtm = './cache/gcp_'. $centered .'.htm';break;
        case 'topSites':  $imageCachefileSrc = './cache/tsp_'. $centered .'.jpg';$imageCachefileHtm = './cache/tsp_'. $centered .'.htm';break;
        default:$imageCachefileSrc = './cache/cfp_'. $centered .'.jpg';$imageCachefileHtm = './cache/cfp_'. $centered .'.htm';
    }
    
//$cov->set_htmlImagemapName('coverflow1');



$echoCoverFlowHTML = '';



function createNoimage($topath='./cache/noimag.jpg', $nopath='./n0', $title='' ) {
	$noImgGD = imagecreatetruecolor(400, 300);
	$bg = imagecolorallocate($noImgGD, 255, 255, 255);
	$frame = imagecolorallocate($noImgGD, 0, 0, 255);
	$textcolor = imagecolorallocate($noImgGD, 127, 120, 0);
	$textcolor2 = imagecolorallocate($noImgGD, 0, 0, 0);
	
	imagefill($noImgGD, 0, 0, $bg);
	
	imageline($noImgGD, 10, 10, 390, 10, $frame);
	imageline($noImgGD, 390, 10, 390, 290, $frame);
	imageline($noImgGD, 390, 290, 10, 290, $frame);
	imageline($noImgGD, 10, 290, 10, 10, $frame);
	
	imagestring($noImgGD, 5, intval(400/2)-30, intval(300/2)-30, 'I M A G E', $textcolor);
	
	imagestring($noImgGD, 5, intval(400/4), intval(300/2)-10, 'Not valid image in path.', $textcolor);
	
	imagestring($noImgGD, 2, intval(400/8), intval(300/2)+40, $nopath , $textcolor2);
	
	imagestring($noImgGD, 3, intval(400/8), intval(300/2)+80, $title , $textcolor2);
	
	imagejpeg( $noImgGD, $topath, 90 ); 
} //createNoimage()



if( !is_file( $imageCachefileSrc ) ) {

	$cov = new coverflow($width,$height);
	$cov->set_reflectionHeight(2.1); // 4.5
	//$cov->set_bgWhite(); // default
	$cov->set_bgBlack();

	
	switch($cftype){
	    case 'coverFlow': $cov->set_use_coverFlow();break;
	    case 'gameCards': $cov->set_use_gameCards();break;
	    case 'topSites':  $cov->set_use_topSites();break;
	    default:$cov->set_use_coverFlow();
	}
    
	foreach( $coversArray as $coverId => $cover ) {
		
		if( $centered == $coverId ) {
			$url = $cover[2];
			$target='_blank';
		} else {
			$url = '?cfp=' . $coverId;
			$target='_self';
		}
		
		if( is_file( $cover[0] ) && is_readable( $cover[0] ) )
			$cov->set_cover($cover[0]);
		else  {
			$noimagepath = './cache/tmp_'.md5($cover[0]).'.jpg';
			if(strlen($cover[0]) > 32 ) 
			{ $cover_subst_path = substr($cover[0], -31 ); $ellip_0 = '...'; }
			else 
			{ $cover_subst_path = substr($cover[0], 0-strlen($cover[0]) ); $ellip_0 = ''; }
			
			if(strlen($cover[1]) > 32 ) 
			{  $cover_subst_title = substr($cover[1], 0, 32); $ellip_1 = '...'; }
			else 
			{ $cover_subst_title = substr($cover[1], 0, strlen($cover[1])); $ellip_1 = ''; }
			
			if( !is_file( $noimagepath ) && !is_readable($noimagepath ) )
				createNoimage($noimagepath, $ellip_0.$cover_subst_path, $cover_subst_title.$ellip_1 );
			$cov->set_cover( $noimagepath );
		}
		
		$cov->set_htmlAtag($coverId, $cover[1], $url, $target );
		
		}
	
	$cov->set_coverCentered( $centered );
	

	$cov->get_imageJpeg( $imageCachefileSrc );
	//$cov->get_imagePng( $imageSrc );
	
	$imageHtmlToCache =
		'<h2>' . $coversArray[$centered][1] . '</h2>'
		. '<img src="'. $imageCachefileSrc .'" usemap="'.$cov->get_htmlImagemapName()
		.'" alt="_" width="'.$width.'" height="'.$height.'" border="0" />'
		. $cov->get_htmlImagemap();
	
	file_put_contents_($imageCachefileHtm, $imageHtmlToCache );
	
	$echoCoverFlowHTML = $imageHtmlToCache;
	
	
	

} else {
		
	$echoCoverFlowHTML = file_get_all ( $imageCachefileHtm );
	
}
	
	//Invisible, 0x0 images
	$BrowserCache = '';
	for( $i = 0 ; $i < $countcoversArray; $i++ ) {		
		if( is_file( './cache/cfp_'. $i .'.jpg' ) )
			$BrowserCache .= '<img src="./cache/cfp_'. $i .'.jpg" width="0" height="0" border="0" alt="" />';
	
	}


	$pageLinks = "\n\n<p>";
	for( $i = 0 ; $i < $countcoversArray; $i++ ) {
		if( $i > 0 ) $pageLinks .= ' &nbsp;&nbsp ';
		if( $centered == $i )
			$pageLinks .= '<span style="font-size:small;">' . ($i+1) . '</span>';
		else
			$pageLinks .= '<a href="?cfp=' . $i . '&cft='.$cftype.'" style="font-size:large;">'. ($i+1) .'</a>';
	}
	$pageLinks .="</p>\n\n";


echo 
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?xml version="1.0" encoding="ISO-8859-1" ?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="content-type" content="text/html; charset=ISO-8859-1" />
    <title>PHP Class coverFlow Example</title>
	<style>
	h2 { font-size:13pt;}
	a, a:link, a:hover, a:visited{ color:blue;text-decoration:none; }
	a:active { color:blue;text-decoration:underlined; }
	
	</style>
<body style="background:white;" >
	
	<p style="margin: 0 0 0 0;padding:0 0 0 0;font-family:times;font-size:12pt;"><a href=".." style="color:#0000FF;text-decoration:none;">&lt;&lt;&lt; Top Site</a></p>
    
	<h1>PHP Class coverFlow Example</h1>
	<p>Please visit my <a href="http://dreamplayer.deviantart.com/art/PHP-class-coverFlow-130480029">deviantART</a> or <a href="http://www.phpclasses.org/browse/package/5549.html">PHP Classes</a> page for information!</p>
	<p>Click on the centered image to see original or click on the smaller ones to move in gallery.</p>
'

.'<p>Select type of presentation: <a href="?cfp='.$centered.'&cft=coverFlow">coverFlow</a> <!-- | <a href="?cfp='.$centered.'cft=topSites">topSites</a> --> | <a href="?cfp='.$centered.'cft=gameCards">gameCards</a></p>'

.$pageLinks
. $echoCoverFlowHTML 
. $BrowserCache . '
    </body>
</html>';





/////////////////////////////////////////////////////////////////////////////////




/**
* Write a string to a file.
* Uses function file_put_contents if available
* This function is binary-safe.
* For perfomance reasons by default multi-dimensional array supported in php4
*
* @author Uku-Kaarel J&otilde;esaar http://ukj.pri.ee
* @param string $filename The file name where to write the data
* @param mixed $data The data to write. Can be either a string, an array or a stream resource.
* @param int $flags FILE_USE_INCLUDE_PATH, FILE_APPEND and/or LOCK_EX
* @param resource $context A context resource
* @return int
*/
function file_put_contents_($filename,$data,$flags=NULL,$context=NULL) {


	//(PHP 5)
	if(function_exists('file_put_contents'))
		return file_put_contents($filename,$data,$flags,$context); //supports 1d arr

	$flockr=TRUE;
	$mode='wb';
	$use_include_path=FALSE;

	if($flags&FILE_USE_INCLUDE_PATH)$use_include_path=TRUE;
	if($flags&FILE_APPEND)$mode='ab';

	eval("\$handle=fopen(\$filename ,\$mode ,\$use_include_path".
	(is_resource($context)?",\$context":'').");");

	if(!$handle)
		return FALSE;
	//5.1.0 //PHP 4.0.1
	if($flags&LOCK_EX)
		$flockr=flock($handle,LOCK_EX);

	if($flockr){
		if(is_array($data))
			if(function_exists('fwrite_array'))
				$fwriter=fwrite_array($handle,$data);
			else
				$data=implode('',$data);
		else
			$fwriter=fwrite($handle,$data);
	}
	fclose($handle);

	return $fwriter;
} //end file_put_contents_()




/** 
 * Read whole file into string
 *
 * @param string filename
 * @return string FALSE if failure
 */
function file_get_all ( $filename ) {
	
	if(!is_file( $filename )) return FALSE;
	if(!is_readable( $filename )) return FALSE;
		
	$r = @fopen($filename,'rb');
		
	if(is_resource( $r )) {
		fseek($r,0,SEEK_END);
		$filesize = ftell($r);
		rewind( $r );
		
		$re = '';
		
		if($filesize > 0) {
			while (!feof($r)) {
			  $re .= @fread($r, 8192);
			}
		}
		else	
			$re = '';
		
		fclose( $r );
		return $re;
	}
	return FALSE;
		
} //end file_get_all()








?>
