<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */

/*
 * TODO: testGradients.php , shows a lot errors: 
 * Warning: Division by zero in C:\xampp\htdocs\dv\class.imagegradient.php(419) : 
 * eval()'d code on line 16
 */

/**
 * General purpose class for creating gradients.
 *
 * To Do
 * diagonal gradients, if one side is very tall, then noise on gradients with aplha. 
 * Alpha sphere is no real sphere.
 * Color transition, if one color with alpha, use other as full opaque? 
 * Some new directions.
 *
 * @package coverFlow
 * @author Uku-Kaarel J&otilde;esaar, http://ukj.pri.ee
 * @version 2.0.0a - full alpha support with bugs
 */
class imagegradient {

/**
 * GD Image.
 * @var resource $im
 */
var $im;



/**
 * The constructor.
 *
 * @param resource $im GD Image
 * @return none
 */
function imagegradient( & $im ) {
	$this->im = & $im;
	//imagealphablending($this->im, true);
	//imagesavealpha($this->im, false);
	
} //imagegradient()




/** 
 * Return an array that contain the gradient.
 *
 * @param array $b start color
 * @param array $c final color
 * @param integer $n steps
 * @param bool $shade if TRUE [ $b ---> $c <--- $b 
 * @return array colors; ex.: array( array(r0,g0,b0),array(r1,g1,b1),array(r2,g2,b2) )
 */
function color_transition($b, $c, $n,$shade=FALSE) {
	
	// To Do: if only one alpha is set, use orthes as full opaque
	
	//echo print_r($b,1) .", ". print_r($c,1).", ".print_r($n,1)." ;";
	
	if( $shade===true ) $n = floor($n/2);
	
	//if least one are set && if both alphas are set
	    if(isset($b[3]) && !isset($c[3])){ $c[3] = 0; }
	elseif(!isset($b[3]) && isset($c[3])){ $b[3] = 0; }
	
	if(!isset($b[3],$c[3])) $isAlpha = FALSE; else $isAlpha = TRUE;
	
	$red_start	= $b[0];	$green_start	= $b[1];	$blue_start	= $b[2];
	$red_end	= $c[0];	$green_end  	= $c[1];	$blue_end	= $c[2];
	
	if($isAlpha) { 
		$alpha_start = $b[3]; 
	  	$alpha_end   = $c[3]; 
	
		if( $b[3] > 127 ) $b[3] = 127; elseif( $b[3] < 0 ) $b[3] = 0;
		if( $c[3] > 127 ) $c[3] = 127; elseif( $c[3] < 0 ) $c[3] = 0;
		
		if($b[3]>=$c[3]) $rgbd[3] = ($b[3]-$c[3]); else $rgbd[3] = ($c[3]-$b[3]);
		
		$step_alpha = ( $rgbd[3] / $n);
	}
    
	// difference between start and end	
	if($b[0]>=$c[0]) $rgbd[0] = ($b[0]-$c[0]); else $rgbd[0] = ($c[0]-$b[0]);
	if($b[1]>=$c[1]) $rgbd[1] = ($b[1]-$c[1]); else $rgbd[1] = ($c[1]-$b[1]);
	if($b[2]>=$c[2]) $rgbd[2] = ($b[2]-$c[2]); else $rgbd[2] = ($c[2]-$b[2]);
		
	$colorDif = $rgbd;

	
	// width of one color step
	$step_red = ( $rgbd[0] / $n) ;
	$step_green = ( $rgbd[1] / $n) ; 
	$step_blue = ( $rgbd[2] / $n) ; 
	
	//echo "$step_red , $step_green, $step_blue";
	
	for ($i = 0 ; $i <= $n ; $i++) {
	
		if( $red_start>$red_end ) $red = $red_start - ($step_red * $i);
		else $red = $red_start + ($step_red * $i);

		if( $blue_start>$blue_end ) $blue = $blue_start - ($step_blue * $i);
		else $blue = $blue_start + ($step_blue * $i);
		
		if( $green_start>$green_end ) $green = $green_start - ($step_green * $i);
		else $green = $green_start + ($step_green * $i);
		
		if( $isAlpha ) {
			if( $alpha_start>$alpha_end ) $alpha = $alpha_start - ($step_alpha * $i);
			else $alpha = $alpha_start + ($step_alpha * $i);
			
			$GradientColor[] = array(round($red) ,round($green) ,round($blue), round($alpha));
		
		} else
			
			$GradientColor[] = array(round($red) ,round($green) ,round($blue));
		
	}
	
	if( $shade===TRUE ) {
		$ShadeColorRev = Array_reverse($GradientColor);
		array_pop ($GradientColor);
		$shade = Array_merge($GradientColor ,$ShadeColorRev );
		unset($ShadeColorRev);
		unset($ShadeColor);
		return $shade;
	}
		
	//print_r ( $GradientColor );
	return $GradientColor;

}// color_transition()







/**
 * Color transition on vertical axis, top to bottom.
 *
 * <code>
 * --------  |
 * ........  |
 * ========  V
 * </code>
 *
 * @param mixed $startcol
 * @param mixed $endcol
 * @param int $gx top-left corner x
 * @param int $gy top-left corner y
 * @param int $width
 * @param int $height
 * @param bool $shade
 * @return none
 */
function top2bottom($startcol=array(0,0,0,0),$endcol=array(255,255,255,127),$gx=0,$gy=0,$width=100,$height=10,$shade=false) {
	$a = $this->color_transition($startcol , $endcol, $height ,$shade);
			
	if( function_exists('imagecolorallocatealpha')  && isset($startcol[3],$endcol[3]) ) 
		$esc = "\$color = imagecolorallocatealpha(\$this->im,\$a[\$pos][0],\$a[\$pos][1],\$a[\$pos][2],\$a[\$pos][3]);";
	else
		$esc = "\$color = ImageColorAllocate(\$this->im,\$a[\$pos][0],\$a[\$pos][1],\$a[\$pos][2]);";

	
	//PREPARE
	$evalExec="
			for (\$pos=0; \$pos<$height;\$pos++) {
				$esc
				imageline( \$this->im, $gx, $gy+\$pos,    $gx+$width, $gy+\$pos,\$color);

			}
	";
	// EXECUTE
	eval($evalExec);
}// top2bottom()

	
	
/**
 * Color transition on horizontal axis, left to right.
 *
 * <code>
 * ------->
 * I II III
 * </code>
 *
 * @param mixed $startcol
 * @param mixed $endcol
 * @param int $gx top-left corner x
 * @param int $gy top-left corner y
 * @param int $width
 * @param int $height
 * @param bool $shade
 * @return none
 */
function left2right($startcol=array(0,0,0,0),$endcol=array(255,255,255,127),$gx=0,$gy=0,$width=100,$height=10,$shade=false) {
	
    $width=$width+$gx-1;
	$a = $this->color_transition($startcol , $endcol, $width ,$shade);
	
	if( function_exists('imagecolorallocatealpha')  && isset($startcol[3],$endcol[3]) ) 
		$esc = "\$color = imagecolorallocatealpha(\$this->im,\$a[\$pos][0],\$a[\$pos][1],\$a[\$pos][2],\$a[\$pos][3]);";
	else
		$esc = "\$color = ImageColorAllocate(\$this->im,\$a[\$pos][0],\$a[\$pos][1],\$a[\$pos][2]);";
			
	//PREPARE 
	$evalExec="
			for (\$pos=0; \$pos<$width;\$pos++) {
				$esc
				imageline( \$this->im, $gx+\$pos,$gy,    $gx+\$pos,$gy+\$height,\$color);
			}
	";
	// EXECUTE
	eval($evalExec);	

	
}//left2right()
	
	
	
/**
 * Color transition. diagonal top-left to bottom-right
 *
 * @param mixed $startcol
 * @param mixed $endcol
 * @param int $gx top-left corner x
 * @param int $gy top-left corner y
 * @param int $width
 * @param int $height
 * @param bool $shade
 */	
function diag_tl2br($startcol=array(255,127,0),$endcol=array(127,255,0),$gx=0,$gy=0,$width=100,$height=10,$shade=false) { 
	$evalExec =" 
	imageline( \$this->im, 	\$gx+\$i,\$gy,	    \$gx,\$gy+\$cy,	\$colorT); // top-x-right-y
	imageline( \$this->im,	\$gx+\$i,\$gy+\$height,	\$gx+\$width,\$gy+\$cy,	\$colorB); // left-y-bot-x
	";
	$this->gradient_diagonals($startcol,$endcol,$gx,$gy,$width,$height,$evalExec,$shade);
	
} //diag_tl2br()
	
	
	
/**
 * Color transition. diagonal top-right to bottom-left
 *
 * @param mixed $startcol
 * @param mixed $endcol
 * @param int $gx top-left corner x
 * @param int $gy top-left corner y
 * @param int $width
 * @param int $height
 * @param bool $shade
 */	
function diag_tr2bl($startcol=array(255,127,0),$endcol=array(127,255,0),$gx=0,$gy=0,$width=100,$height=10,$shade=false) { 
	$evalExec ="
	imageline( \$this->im, 	\$gx+\$width-\$i,\$gy,	    \$gx+\$width,\$gy+\$cy,	\$colorT); // YL
	imageline( \$this->im,	\$gx+\$width-\$i-1,\$gy+\$height-1,	\$gx,\$gy+\$cy,	\$colorB); // AL
	";
	$this->gradient_diagonals($startcol,$endcol,$gx,$gy,$width,$height,$evalExec,$shade);

} // diag_tr2bl()
	
	
	
	
	
/**
 *  Gradient filled sphere, no-alpha optimized.
 *
 * @param string $startcol Outer
 * @param string $endcol Center
 * @param int $gx center x
 * @param int $gy center y
 * @param int $lenght diameter
 * @param int $height
 * @param bool $shade
 */
function gradient_sphere_noalpha($startcol=array(255,255,255),$endcol=array(0,0,0),$gx=0,$gy=0,$lenght=100, $shade=false) {

	$lenght= (int) $lenght;
	$radius = intval($lenght / 2);
	
	$col = $this->color_transition($startcol, $endcol, $lenght, $shade);
	
	$evalExec="
		    
		for (\$pos=$lenght; \$pos>0; \$pos-- ) {
		
		\$color = imagecolorallocate(\$this->im, \$col[\$pos][0], \$col[\$pos][1], \$col[\$pos][2]);
		
		imagefilledarc(\$this->im, $gx, $gy, \$pos, \$pos, 0, 0, \$color, IMG_ARC_PIE );
		 
		}
			
	";
	// EXECUTE
	eval($evalExec);
	
	return TRUE;
}//gradient_sphere_noalpha()

	
	
/**
 *  gradient filled sphere
 *
 * This is modified gdImageFilledEllipse('Pierre-Alain Joye', '02/08/2003', 'paj@pearfr.org')
 *
 * @param string $startcol color on side
 * @param string $endcol color in center
 * @param int $mx center x
 * @param int $my center y
 * @param int $diam diameter
 * @param bool $shade
 */
function gradient_sphere($startcol=array(255,255,255),$endcol=array(0,0,0), $mx=0, $my=0, $diam=100, $shade=false)
{

    if( !function_exists( 'ImageColorAllocatealpha' ) || !isset($startcol[3],$endcol[3]) ) {
        $this->gradient_sphere_noalpha($startcol, $endcol, $mx, $my, $diam, $shade );
        return TRUE;
    }

    $w = $h = $diam;
    $a = $b = floor($diam/2);
     
    $x = $mx1 = $mx2 = $my1 = $my2 = $aq = $bq     = $dx     = $dy = 0;
    $r = $rx  = $ry  =               $i  = $old_y1 = $old_y2       = 0;
    // (int) current color
    $cic = 0;
    //(float) color iterator, (float) color iterator coefficient
    $ci = $cik = 0.0;
    

    $mx1 = (int) ($mx-$a)+1; $my1 = $my-1;
    $mx2 = (int) ($mx+$a)-1; $my2 = $my+1;
    //die( " mx1 = $mx1, my2 = $my2 ; " );
    
    // Generates array of colors
    $col = $this->color_transition($startcol , $endcol, $a, $shade);
     
    $esc = "if(\$xi>".($a-1).")\$x=".($a-1).";
            else \$x=\$xi;
            \$c = ImageColorAllocatealpha(\$this->im ,\$col[\$x][0],\$col[\$x][1],\$col[\$x][2],\$col[\$x][3]);
            ";
    /*
    eval("
    for (\$xi = 0; \$xi <= $a; \$xi++) {
        $esc
        imagesetpixel(\$this->im, $mx1+\$xi , $my, \$c);
        imagesetpixel(\$this->im, $mx2-\$xi+1 , $my, \$c);
    }
    ");
       */
    $aq = $a * $a;
    $bq = $b * $b;
    $dx = ($aq << 1);
    $dy = ($bq << 1);
    $r  = $a * $bq;
    $rx = $r << 1;
    $ry = 0;
    $x  = $a;
    $old_y2=$my;
    $old_y1=$my;
	
	$esc = "\$c = ImageColorAllocatealpha(\$this->im ,\$col[\$cic][0],\$col[\$cic][1],\$col[\$cic][2],\$col[\$cic][3]);";
    /* if(function_exists( 'ImageColorAllocatealpha' ) && isset($startcol[3],$endcol[3]) ) {
        $esc = "\$c = ImageColorAllocatealpha(\$this->im ,\$col[\$cic][0],\$col[\$cic][1],\$col[\$cic][2],\$col[\$cic][3]);";
    } else {
        $esc = "\$c = ImageColorAllocate(\$this->im ,\$col[\$cic][0],\$col[\$cic][1],\$col[\$cic][2]);";
    } */
                
    eval(" 
    while (\$x >= 0) {
        if (\$r > 0) {
	        \$my1++;\$my2--;
	        \$ry +=\$dx;
	        \$r  -=\$ry;
        }
        if (\$r <= 0){
	        \$x--;
	        \$mx1++;\$mx2--;
	        \$rx -=\$dy;
	        \$r  +=\$rx;
        } //line13
        \$mx22 = ceil ( \$mx1+ ( (\$mx2-\$mx1) /2) );
        
        if($a-(\$my1-$my)==0)break;
        if((\$mx22 - \$mx1)==0)break;
        
        \$cik = ceil($a-(\$my1-$my)); // color index coeficient
        \$ci = 1/(ceil(\$mx22 - \$mx1) / \$cik); //eval/()'d code on line 17
        
            
        \$cii = 0;  
        if(\$old_y2!=\$my2){
	        \$cic = 0;
	        for(\$i=\$mx1;\$i<=\$mx22;\$i++) {		
		        \$cic = floor( \$cii );
		        $esc
		        
		        // bottom side of sphere
		        imagesetpixel(\$this->im, \$i, \$my1, \$c);
		        imagesetpixel(\$this->im, \$mx2+\$mx1-\$i+1 ,\$my1, \$c);
		        
		        // top side of sphere
		        imagesetpixel(\$this->im,\$i,\$my2+1,\$c);
		        imagesetpixel(\$this->im,\$mx2+\$mx1-\$i+1,\$my2+1,\$c);
		        
		        if(\$cik >= \$cic) \$cii += \$ci;
	        }
        }
        \$old_y2 = \$my2;
        \$old_y1 = \$my1;
    }
    //echo '<hr />';
    ");//eval() // 382
	/*
	// centre of sphere
	$c = ImageColorAllocate($this->im ,0,127,255);
	imagesetpixel($this->im,$mx,$my,$c);
	imagesetpixel($this->im,$mx-1,$my,$c);imagesetpixel($this->im,$mx-2,$my,$c);
	imagesetpixel($this->im,$mx+1,$my,$c);imagesetpixel($this->im,$mx+2,$my,$c);
	imagesetpixel($this->im,$mx,$my-1,$c);imagesetpixel($this->im,$mx,$my-2,$c);
	imagesetpixel($this->im,$mx,$my+1,$c);imagesetpixel($this->im,$mx,$my+2,$c);
	// border immediately outside of sphere
    imagearc($this->im, $mx, $my, $diam+1, $diam+1,  0, 360, $c);
    imageline($this->im, $mx-$a+1, $my, $mx-$a+5, $my, $c);
    */
} //gradient_sphere()
	
	
/**
 * Apply gradient on specified area
 *
 * radial quarter [|_] [_|] [|-] [7]
 *
 * @param string $startcol #rrggbb is in center
 * @param string $endcol #rrggbb is the edge
 * @param int $gx top-left corner x
 * @param int $gy top-left corner y
 * @param int $len 
 * @param string $dir direction
 * @return none
 */	
function gradient_cor($startcol=array(0,0,0),$endcol=array(255,255,255),$gx=0,$gy=0,$len=50,$dir='tl' ) {
	
	$lenc=(2*$len)-1;
	
	// there is gradient array // array( 0=>r,1=>g,2=>b);
	$a = $this->color_transition($startcol , $endcol, $lenc,false);
	
	//echo $len.', '; //print_r( $startcol ) ;  print_r ($endcol ); //print_r( $gcol_a );

	$gxw= (int)($gx+$len);
	$gyh= (int)($gy+$len);
	
			
	// PREPARE DIRECTION TYPE
		if($dir=='tl'){ 
			//$evalExec_dirtype = " imagefilledarc(\$this->im, $gxw,$gyh,      \$pos,	\$pos, 180, 270, \$color, IMG_ARC_PIE); "; 
			$evalExec_dirtype = " imagearc(\$this->im, $gxw,$gyh,      \$pos,	\$pos, 180, 270, \$color); "; 
			} //TL
	elseif($dir=='tr'){ 
		//$evalExec_dirtype = " imagefilledarc(\$this->im, $gx,$gyh,		\$pos,	\$pos, 270,   0, \$color, IMG_ARC_PIE); "; 
		$evalExec_dirtype = " imagearc(\$this->im, $gx,$gyh,		\$pos,	\$pos, 270,   0, \$color); "; 
		} //TR
	elseif($dir=='bl'){ 
		//$evalExec_dirtype  = " imagefilledarc(\$this->im, $gxw,$gy,		\$pos,	\$pos,  90, 180, \$color, IMG_ARC_PIE); ";
		$evalExec_dirtype  = " imagearc(\$this->im, $gxw,$gy,		\$pos,	\$pos,  90, 180, \$color); ";
		} //BL
	elseif($dir=='br'){ 
		//$evalExec_dirtype = " imagefilledarc(\$this->im, $gx,$gy,		\$pos,	\$pos,   0,  90, \$color, IMG_ARC_PIE); "; 
		$evalExec_dirtype = " imagearc(\$this->im, $gx,$gy,		\$pos,	\$pos,   0,  90, \$color); "; 
		} //BR
	
	
	if( function_exists('imagecolorallocatealpha') && isset($startcol[3],$endcol[3]) ) {
		//imagefilledrectangle ( $this->im,	$gx,$gy,	$gxw,$gyh, imagecolorresolvealpha($this->im, $endcol[0], $endcol[1], $endcol[2], $endcol[3]) );

		$esc = "\$color = imagecolorallocatealpha(\$this->im,\$a[\$pos][0],\$a[\$pos][1],\$a[\$pos][2],\$a[\$pos][3]);";
	} else {
		//imagefilledrectangle ( $this->im,	$gx,$gy,	$gxw,$gyh, imagecolorresolve($this->im, $endcol[0], $endcol[1], $endcol[2]) );

		$esc = "\$color = ImageColorAllocate(\$this->im,\$a[\$pos][0],\$a[\$pos][1],\$a[\$pos][2]);";
	}
	
	
	$evalExec="
			imagesetthickness(\$this->im, ". ceil($lenc/36) ." );
			for (\$pos=$lenc; \$pos>0;\$pos -=". ceil($lenc/36) ." ) {
				$esc
				$evalExec_dirtype
			}
	";
	eval($evalExec);
	imagesetthickness($this->im, 1 );

}  //gradient_cor()








/**
 * Color transition diagonals helper.
 *
 * F jul 31 16:50:42 EEST 2009
 * This works ok with no alpha channel & if alpha is used good result 
 * depends how many longer is one side of gradient than other side.
 *
 * to do: fix problems with alpha
 *
 * @param mixed $startcol
 * @param mixed $endcol
 * @param int $gx top-left corner x
 * @param int $gy top-left corner y
 * @param int $width
 * @param int $height
 * @param bool $shade
 * @return none
 * @access private
 */
function gradient_diagonals($startcol=array(255,127,0),$endcol=array(127,255,0),$gx=0,$gy=0,$width=100,$height=10,$evalExec_i='',$shade=false ) {

    // To Do:
    //  %  how many lines get covered?
    //  %  if alpha is presented, calculate additional alpha, accordingly lines overlaping
    
	$col = $this->color_transition($startcol , $endcol,  (2*$width) ,$shade);
	
	if( function_exists('imagecolorallocatealpha') && isset($startcol[3],$endcol[3]) ) {
		    $esc = "
		\$colorT = imagecolorallocatealpha(\$this->im , \$col[\$i][0], \$col[\$i][1], \$col[\$i][2], \$col[\$i][3] );
		\$colorB = imagecolorallocatealpha(\$this->im , 
			\$col[(\$i+\$width)][0], 
			\$col[(\$i+\$width)][1], 
			\$col[(\$i+\$width)][2],
			\$col[(\$i+\$width)][3] 
			 );
			";
		
	} else {
		   $esc = "
		\$colorT = ImageColorAllocate(\$this->im , \$col[\$i][0], \$col[\$i][1], \$col[\$i][2] );
		\$colorB = ImageColorAllocate(\$this->im , 
			\$col[(\$i+\$width)][0], 
			\$col[(\$i+\$width)][1], 
			\$col[(\$i+\$width)][2]
			);
		";
	}
	
	
	// This implementation is good for opaque gradient
	$i = $cy=0;
	$sonh=($height/$width); // exact how many lines need draw per one cycle
	$sonh_cs=ceil($sonh); // entrie lines
	$sonh_csa=($sonh/$sonh_cs); // exact y cordinate
	$evalExec="
	while( \$i<\$width ) {
		$esc
				
		\$iy=0;
		while( \$iy<\$sonh_cs ) {
			
			$evalExec_i
			
			if( \$iy>=\$sonh or \$cy==\$height ) break;
			
			if( \$sonh>1 ) { \$cy=\$cy+\$sonh_csa; } 
			else { \$cy=\$cy+\$sonh; }
			
			\$iy++;
		}
		\$i++;
	}
	";
	eval( $evalExec );
} // gradient_diagonals()







} //end class


?>
