<?php


/**
* filesplit class : Split big text files in multiple files
*
* @package
* @author Ben Yacoub Hatem <info@phptunisie.net>
* @copyright Copyright (c) 2004-2005
* @version $Id$ - filesplit.class.php,v 1.1 2005/02/27 22:41:22 hatem Exp $ 1.1
* @access public
**/
class filesplit{
	/**
     * Constructor
     * @access protected
     */
	function filesplit(){
		
	}
	
	/**
	 * File to split
	 * @access private
	 * @var string
	 **/
    var $_source = 'logs.txt';
	
	/**
	 * 
	 * @access public
	 * @return string 
	 **/
    function Getsource(){
		return $this->_source;
	}
	
	/**
	 * 
	 * @access public
	 * @return void
	 **/
	function Setsource($newValue){
		$this->_source = $newValue;
	}
	
	/**
	 * how much lines per file
	 * @access private
	 * @var integer
	 **/
    var $_lines = 1000;
	
	/**
	 * 
	 * @access public
	 * @return integer 
	 **/
    function Getlines(){
		return $this->_lines;
	}
	
	/**
	 * 
	 * @access public
	 * @return void
	 **/
	function Setlines($newValue){
		$this->_lines = $newValue;
	}
	
	/**
	 * Folder to create splitted files with trail slash at end
	 * @access private
	 * @var string
	 **/
    var $_path = 'logs/';
	
	/**
	 * 
	 * @access public
	 * @return string 
	 **/
    function Getpath(){
		return $this->_path;
	}
	
	/**
	 * 
	 * @access public
	 * @return void
	 **/
	function Setpath($newValue){
		$this->_path = $newValue;
	}

	/**
	 * filesplit::configure()	Configure the class
	 * 
	 * @param string $source
	 * @param string $path
	 * @param string $lines
	 * @return 
	 **/
	function configure($source = "",$path = "",$lines = ""){
		if ($source != "") {
		    $this->Setsource($source);
		}
		if ($path!="") {
		    $this->Setpath($path);
		}
		if ($lines!="") {
		    $this->Setlines($lines);
		}
	}
	
    
    /**
     * Run the FileSplit process
     * @access public
     * @return void
     **/
    function run(){
        $i=0;
        $j=1;
        $date = date("m-d-y");
        unset($buffer);
        
        $handle = @fopen ($this->Getsource(), "r");
        while (!feof ($handle)) {
          $buffer .= @fgets($handle, 4096);
          $i++;
		  
		  if ($i >= $this->_lines) {
		  
			  $fname = $this->Getpath()."part.$date.$j.txt";
			  
			   if (!$fhandle = @fopen($fname, 'w')) {
					print "Cannot open file ($fname)";
					exit;
			   }
			
			   if (!@fwrite($fhandle, $buffer)) {
				   print "Cannot write to file ($fname)";
				   exit;
			   }

			   fclose($fhandle);
			   unset($buffer,$i);
			   $j++;
			}
        }
		
		if (isset($buffer)) {
			  $fname = $this->Getpath()."part.$date.$j.txt";
			  
			   if (!$fhandle = @fopen($fname, 'w')) {
					print "Cannot open file ($fname)";
					exit;
			   }
			
			   if (!@fwrite($fhandle, $buffer)) {
				   print "Cannot write to file ($fname)";
				   exit;
			   }

			   fclose($fhandle);
			   unset($buffer,$i);
		}
        fclose ($handle);
    }
    
    /**
     * Delete all generated part files
     *
     */
    function delete(){
		$d = dir($this->Getpath());
		while (false !== ($entry = $d->read())) {
		   if (ereg("^part",$entry)) {
		   	unlink($this->Getpath()."$entry");
		   }
		}
		$d->close();
		return;
    }
}

?>