<?
/*** Revision History
 ** --------------------------------------------
 ** 19-Aug-2002 Added a check to check if the form variable exists
 ** This will ensure that if you give it an invalid form variable name
 ** to check it will not crash the JavaScript. Thanks to Chris Fortune
 ** at cfortune@telus.net for the idea
 **/


/** This class dynamically creates validation javascript
 ** Currently it is only generating limited comparisons.
 ** I did not want to <b>clutter</b> up the code with
 ** unnecessary test cases when I did not use them
 ** within my system
 ** 
 ** The system is fairly easy to understand and fairly
 ** easy to extend. Just the sort of thing that everyone
 ** has been looking for in a validator :-)
 **
 ** @author Brett Dutton - bdutton@radntech.com
 ** @version 1.1 - 19-Aug-2002
 **/ 
class Validator {
    
    /** Name of the form in this document
     ** @type String 
     ** @private 
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    var $formName;
    
    /** An array of all the form variables that will be tested
     ** @see $add
     ** @type array
     ** @private 
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    var $testCases = array ();

    /** List of used functions. This is used so we
     ** do not generate javascript that we don't need
     ** @type array
     ** @private 
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    var $usedFunct = array ();

    /** 
     ** do not generate javascript that we don't need
     ** @type array
     ** @private 
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    var $alertOnMissingFormVar;

    /** Constructor
     ** @returns void
     ** @public
     ** @param $f The name of the form that will be validated 
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function Validator ( $f ) {
        $this->formName = $f;
        $this->alertOnMissingFormVar = FALSE;
    }

    /** Sets the variable alertOnMissingFormVar. This variable controlles
     ** is there is a message displayed if the javascript is given an
     ** invalid form variable name to test
     ** @returns void
     ** @public
     ** @param $state The state of this variable
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function setMissingAlert ( $state ) { $this->alertOnMissingFormVar = $state; }
    
    /** Add a test for this form variable. Tests for Existance
     ** @returns void
     ** @public
     ** @param $fv Form Variable name
     ** @param $desc A message if the test fails
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function addExists ( $fv, $desc ) { $this->add ( $fv, $desc,  "EXISTS" ); }
    
    /** Add a test for this form variable. Tests for valid email
     ** Note that empty is valid. That means that you must check for
     ** Existance as well as email.
     ** @returns void
     ** @public
     ** @param $fv The form variable name to test
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function addEmail  ( $fv ) { $this->add ( $fv, "", "EMAIL"  ); }

    /** Add a test for this form variable. Tests for 2 form variables
     ** are equal. This is partucually useful for passwords
     ** @returns void
     ** @public
     ** @param $fv1 First form variable to check
     ** @param $fv2 Other form variable to test againse
     ** @param $desc Message if the variables are not the same
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function addEqual  ( $fv1, $fv2, $desc ) { $this->add ( $fv1, $desc, "EQUAL", $fv2 ); }
    
    /** Add a test for this form variable. Tests if a form variable
     ** is empty. If it is then it copies the value from $fv1 into $fv2
     ** This would be useful for say prefered name
     ** @returns void
     ** @public
     ** @param $fv1 Source Form Variable
     ** @param $fv2 Destination Form Variable
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function addCopy   ( $fv1, $fv2 ) { $this->add ( $fv1, "", "COPY", $fv2 ); }
    
    /** Generic function for adding tests
     ** @returns void
     ** @private
     ** @param $fv Form Variable
     ** @param $desc Description for this test
     ** @param $t Test type
     ** @param $xtra Extra information
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function add ( $fv, $desc, $t, $xtra=NULL ) {
        $this->testCases[] = array ( "NAME" => $fv,
                                     "DESC" => $desc,
                                     "TEST" => $t,
                                     "XTRA" => $xtra );
        $this->usedFunct[$t] = "YES";
    }

    /** Generates HTML and Javascript to do the tests on this form
     ** @returns String
     ** @public
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function toHtml () {
        $msg = "";

        // The first stage is to figure out what is being validated and
        // to only include what you want
        $msg .= ( "function isEmpty(s) { return ((s == null) || (s.length == 0)); }\n" );
        $msg .= ( "var whitespace = \" \\t\\n\\r\";\n" . 
                  "function isWhitespace (s) {\n" .
                  "  var i;\n" .
                  "  if (isEmpty(s)) return true;\n" .
                  "  for (i = 0; i < s.length; i++) {\n" .
                  "    var c = s.charAt(i);\n" .
                  "    if (whitespace.indexOf(c) == -1) return false;\n" .
                  "  }\n" .
                  "  return true;\n" .
                  "}\n" );
        
        foreach ( $this->usedFunct as $key => $val ) {
            switch ( $key ) {
            case "EXISTS":  // Output the javascript functions for Existance
                $msg .= ( "function doesExist (s) { return ( ! isEmpty(s) && ! isWhitespace (s) ); }\n" );
                break;
                
            case "EMAIL": // Output the javascript functions for email
                $msg .= "var iEmail = \"This field must be a valid email address (like foo@bar.com). Please reenter it now.\";\n";
                $msg .= ( "function isEmail (s) {\n" . 
                          "  if (isEmpty(s)) return ( true );\n" .
                          "  if (isWhitespace(s)) return ( false );\n" .
                          "  var i = 1;\n" .
                          "  var sLength = s.length;\n" .
                          "  while ((i < sLength) && (s.charAt(i) != \"@\")) { i++; }\n" .
                          "  if ((i >= sLength) || (s.charAt(i) != \"@\")) return ( false );\n" .
                          "  else i += 2;\n" .
                          "  while ((i < sLength) && (s.charAt(i) != \".\")) { i++; }\n" .
                          "  if ((i >= sLength - 1) || (s.charAt(i) != \".\")) return ( false );\n" .
                          "  else return ( true );\n" .
                          "}\n" );
                break;
            }
        }

        // Then create the validation function that will test all the
        // different form variables
        $msg .= "function validateForm() {\n";
        $msg .= "  var form = document.$this->formName;\n";
        foreach ( $this->testCases as $val ) {
            $nam  = $val["NAME"];
            $desc = $val["DESC"];

            // Test is in java and check if the form variable exists
            // Ensures the Javascript does not crash on
            // missing Form Variables
            $msg .= "  if ( form.$nam ) {\n";

            // Output the javascript to do the different checks
            switch ( $val["TEST"] ) {
            case "EXISTS":
                $msg .= "    if ( ! doesExist ( form.$nam.value ) ) {\n";
                $msg .= "      alert ( \"$desc Must Exist\" );\n";
                $msg .= "      form.$nam.focus();\n";
                $msg .= "      return ( false );\n";
                $msg .= "    }\n";
                break;
                
            case "EMAIL":
                $msg .= "    if ( ! isEmail ( form.$nam.value ) ) {\n";
                $msg .= "      alert ( iEmail );\n";
                $msg .= "      form.$nam.focus();\n";
                $msg .= "      return ( false );\n";
                $msg .= "    }\n";
                break;
                
            case "EQUAL":
                $nam2 = $val["XTRA"];
                $msg .= "    if ( form.$nam.value != form.$nam2.value ) {\n";
                $msg .= "      alert ( \"$desc\" );\n";
                $msg .= "      form.$nam.focus();\n";
                $msg .= "      return ( false );\n";
                $msg .= "    }\n";
                break;
                
            case "COPY":
                $nam2 = $val["XTRA"];
                $msg .= "    if ( ! doesExist ( form.$nam2.value ) ) {\n";
                $msg .= "      form.$nam2.value = form.$nam.value\n";
                $msg .= "    }\n";
                break;
            }

            // End of the if test that check if the form var exists
            $msg .= "  }\n";
            
            // Check if we are notifying the user on missing form vars
            if ( $this->alertOnMissingFormVar ) {
                $msg .= "  else {\n";
                $msg .= "    alert ( \"Form variable '$nam' does not exist in this form\" );\n";
                $msg .= "    return ( false );\n";
                $msg .= "  }\n";
            }
        }
        
        $msg .= "  return ( true );\n";
        $msg .= "}\n";
        $msg .= "function validateAndSubmit() {\n";
        $msg .= "  var form = document.$this->formName;\n";
        $msg .= "  var ok = validateForm ();\n";
        $msg .= "  if ( ok ) form.submit ();\n";
        $msg .= "  return ( ok );\n";
        $msg .= "}\n";
        return ( "<script type=\"text/javascript\" language=\"JavaScript\">\n" .
                 $msg .
                 "</script>\n" );
    }

    /** Function to attach some javascript to a Submit button
     ** so that it does the validation. 
     ** @returns String
     ** @public
     ** @param $s Other javascript that is required on this button or link
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function onSubmit ( $s="" ) {
        return ( "onClick=\"{$s}return validateForm();\"" );
    }

    /** This function would be attached to a button or a link. It 
     ** does the validation first and then does a submit on the form
     ** @returns String
     ** @public
     ** @param $s Other javascript that is required on this button or link
     ** @author Brett Dutton - bdutton@radntech.com
     **/ 
    function doSubmit ( $s="" ) {
        return ( "onClick=\"{$s}return validateAndSubmit();\"" );
    }
}


?>