﻿
Public Class _Default
    Inherits System.Web.UI.Page

    ' Declare Object Binders as Page level Variables
    Dim dsCustomer As New ObjectBinder(Of Customer) ' Will be used to bind Customer
    Dim dsAddress As New ObjectBinder(Of Address) ' Will be used to bind Addresses

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If Not Page.IsPostBack Then
            ' Create a dummy Customer
            Dim c As New Customer With {.FirstName = "Razi", .LastName = "Syed", .Email = "emailme@razisyed.com", .Status = "Active"}

            ' Create dummy addresses for the customer
            c.Addresses.Add(New Address With {.AddressLine = "123 Main St.", .City = "Houston", .State = "TX", .ZipCode = "77001"})
            c.Addresses.Add(New Address With {.AddressLine = "987 Second St.", .City = "Austin", .State = "TX", .ZipCode = "77002"})
            c.Addresses.Add(New Address With {.AddressLine = "456 Third St.", .City = "Dallas", .State = "TX", .ZipCode = "77003"})

            ' The Object Binder can be initialized by setting an instance or a list
            ' Not setting an instance will basically create an empty datasource

            dsCustomer.SetInstance(c) ' Set Customer Instance (for FormView)
            dsAddress.SetList(c.Addresses) ' Set Address List (for GridView)

        End If

        ' Bind frmCustomer to Data Source (3 lines of code)
        Dim odsCustomer = dsCustomer.GetDataSource
        phDataSources.Controls.Add(odsCustomer)
        frmCustomer.DataSourceID = odsCustomer.ID

        ' Bind grdAddresses to Data Source 
        Dim odsAddresses = dsAddress.GetDataSource
        phDataSources.Controls.Add(odsAddresses)
        grdAddresses.DataSourceID = odsAddresses.ID

        ' That's pretty much it! The customer and addresses will be displayed to the user. 
        ' If the user edits/inserts/deletes using the formview or gridview, it will automatically update the object
        ' The best part is that you can retrieve the object as shown below, without searching for controls and assigning properties manually.

    End Sub

    Protected Sub btnView_Click(sender As Object, e As EventArgs) Handles btnView.Click
        ' Get Customer Object from UI without any effort

        Dim c As Customer = dsCustomer.Instance ' Get an instance (for FormView)
        c.Addresses = dsAddress.List ' Get a list (for GridView)

        Dim output As String = "Customer: <br>" & _
                               "First Name: " & c.FirstName & "<br>" & _
                               "Last Name: " & c.LastName & "<br>" & _
                               "Email: " & c.Email & "<br>" & _
                               "Status: " & c.Status & "<br>" & _
                               "<br>" & _
                               "Addresses:<br>"

        For Each a As Address In c.Addresses
            output &= a.AddressLine & ", " & a.City & ", " & a.State & " " & a.ZipCode & "<br>"
        Next

        lblOutput.Text = output
    End Sub
End Class