﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="Default.aspx.vb" Inherits="ObjectBinderSolution._Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>ObjectDataSource Binding Demo</title>
    <style type="text/css">
        body {font-family: Arial; font-size: 10pt; }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <b>ObjectBinder Test by Razi Syed<br />
        </b><br />
        This tests Binding .Net controls like FormView and GridView to an Object with minimal coding and efforts. <br />
        The key is that the controls automatically update an object's values in FormView, and also Insert, Update or Delete and item from List.<br />
        <br />
        <!-- FormView to Bind with Customer -->
        <asp:FormView ID="frmCustomer" runat="server" DataKeyNames="CustomerID">
            <ItemTemplate>
                First Name: <asp:Label ID="lblFirstName" runat="server" Text='<%# Eval("FirstName") %>'></asp:Label><br />
                Last Name: <asp:Label ID="lblLastName" runat="server" Text='<%# Eval("LastName") %>'></asp:Label><br />
                Email: <asp:Label ID="lblEmail" runat="server" Text='<%# Eval("Email") %>'></asp:Label><br />
                Status: <asp:Label ID="lblStatus" runat="server" Text='<%# Eval("Status") %>'></asp:Label><br />                
                <asp:LinkButton ID="lnkEdit" runat="server" CommandName="Edit">Edit</asp:LinkButton>
            </ItemTemplate>
            <EditItemTemplate>
                <asp:TextBox ID="txtFirstName" runat="server" Text='<%# Bind("FirstName") %>'></asp:TextBox><br />
                <asp:TextBox ID="txtLastName" runat="server" Text='<%# Bind("LastName") %>'></asp:TextBox><br />
                <asp:TextBox ID="txtEmail" runat="server" Text='<%# Bind("Email") %>'></asp:TextBox><br />
                <asp:DropDownList ID="ddlStatus" runat="server" SelectedValue='<%# Bind("Status") %>'>
                    <asp:ListItem Text="Active" Value="Active"></asp:ListItem>
                    <asp:ListItem Text="Inactive" Value="Inactive"></asp:ListItem>
                </asp:DropDownList>
                <br />
                <asp:LinkButton ID="btnSave" runat="server" CommandName="Update">Update</asp:LinkButton>&nbsp;
                <asp:LinkButton ID="btnCancel" runat="server" CommandName="Cancel">Cancel</asp:LinkButton>
            </EditItemTemplate>
        </asp:FormView>
        <br />
        <!-- GridView to Bind with Customer Addresses -->
        <asp:GridView ID="grdAddresses" runat="server" AutoGenerateColumns="False" DataKeyNames="AddressID">
            <Columns>
                <asp:BoundField DataField="AddressLine" HeaderText="Address" />
                <asp:BoundField DataField="City" HeaderText="City" />
                <asp:BoundField DataField="State" HeaderText="State" />
                <asp:BoundField DataField="ZipCode" HeaderText="Zip" />
                <asp:CommandField ShowEditButton="True" />
                <asp:CommandField ShowDeleteButton="True" />
            </Columns>
        </asp:GridView>
        <!-- Placeholder to Dynamically add DataSources -->
        <asp:PlaceHolder ID="phDataSources" runat="server"></asp:PlaceHolder>
        <br />
        <br />
        <asp:Button ID="btnView" runat="server" Text="View Objects" />
        <br />
        <asp:Label ID="lblOutput" runat="server" ></asp:Label>
    </div>
    </form>
</body>
</html>
