﻿' Simple Classes to Demonstrate Binding

Public Class Customer
    Implements IEquatable(Of Customer)

    Property CustomerID As String
    Property FirstName As String
    Property LastName As String
    Property Status As String
    Property Email As String

    Property Addresses As New List(Of Address)

    Sub New()
        CustomerID = Guid.NewGuid.ToString
    End Sub


    Public Overloads Function Equals(other As Customer) As Boolean Implements System.IEquatable(Of Customer).Equals
        Return Me.CustomerID.Equals(other.CustomerID)
    End Function
End Class

Public Class Address
    Implements IEquatable(Of Address)

    Property AddressID As String
    Property AddressLine As String
    Property City As String
    Property State As String
    Property ZipCode As String

    Sub New()
        AddressID = Guid.NewGuid.ToString
    End Sub

    Public Overloads Function Equals(other As Address) As Boolean Implements System.IEquatable(Of Address).Equals
        Return Me.AddressID.Equals(other.AddressID)
    End Function
End Class