﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;

namespace FormSubmitBotTest.Models
{
    public class GuestbookModels
    {
        

        [Required]
        [DataType(DataType.Text)]
        [Display(Name = "Name")]
        [StringLength(50,ErrorMessage= "Name must be under 50 characters.")]
        public virtual string Name { get; set; }

        [Required]
        [DataType(DataType.EmailAddress)]
        [Display(Name = "Email Address (For Admin only)")]
        [RegularExpression("^[a-z0-9_\\+-]+(\\.[a-z0-9_\\+-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*\\.([a-z]{2,4})$", ErrorMessage = "Email does not appear to be valid format.")]
        [StringLength(256, ErrorMessage="Email Address Length too long.")]
        public virtual string Email { get; set; }

        [Required]
        [DataType(DataType.Html)]
        [Display(Name = "Message")]
        [StringLength(255, ErrorMessage = "Message must be under 255 characters.")]
        public virtual string Message { get; set; }

        public virtual DateTime Date { get; set; }

    }
}