﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace FormSubmitBotTest.Controllers
{
    public class GuestbookController : Controller
    {
        //
        // GET: /Guestbook/
        public ActionResult Index()
        {
            //Get list of entries to pass to the view
            var entries = from gb in MvcApplication.Guestbook
                          orderby gb.Date descending  
                          select gb;
            
            return View(entries.ToList());
        }

        //
        // GET:/Guestbook/AddEntry
        public ActionResult AddEntry()
        {
            return View();
        }

        //
        // POST: /Guestbook/AddEntry
        [HttpPost]
        public ActionResult AddEntry(FormSubmitBotTest.Models.GuestbookModels model, FormCollection formCollection)
        {

            if (!formCollection["FormEntryBotWatch"].Equals("JS-GOT-ME"))
            {
                ModelState.AddModelError("", "The controller thinks you are a bot, please wait for message to say it is safe to submit entry (30 Seconds)");
            }
            else
            {
                if (ModelState.IsValid)
                {
                    //Add the server Date/Time to the record
                    model.Date = DateTime.Now;

                    //Add the entry to the in memory guestbook
                    MvcApplication.Guestbook.Add(model);

                    //If we got here, everything ok, redirect back to the index
                    return RedirectToAction("Index", "GuestBook");
                }
            }
            return View();

        }

    }
}
