using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using YABlog.BLL;

public partial class ViewEntry : System.Web.UI.Page
{
    EntriesAction ent = new EntriesAction();
    CommentsAction com = new CommentsAction();
    EntryBO entry = null;
    CategoriesAction cat = new CategoriesAction();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["UserId"] == null)
        {
            Response.Redirect("Login.aspx");
        }
        if (!IsPostBack)
        {
            if (Request.QueryString["id"] == null)
            {
                Response.Redirect("default.aspx");
            }

        }             

        entry = ent.GetEntryDetails(Convert.ToInt32(Request.QueryString["id"]));

        Label1.Text = entry.Subject;
        Label2.Text = "Category: " + entry.Category + ", Posted on: " + entry.Date.ToString();

        string body = Format(entry.Body);
        Literal1.Text = Server.HtmlDecode(body);

        int commentCount = com.GetCommentsByEntry(Convert.ToInt32(Request.QueryString["id"]), Repeater1);

        Label3.Text = commentCount.ToString();        
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        if(TextBox1.Text == "" || TextBox2.Text=="")
        {
            return;
        }

        bool ret = com.AddComment(Convert.ToInt32(Request.QueryString["id"]), TextBox1.Text, TextBox2.Text);

        if (ret == true)
        {
            TextBox1.Text = "";
            TextBox2.Text = "";
            
            Page_Load(this, new EventArgs());
        }
    }

    public string Format(string s)
    {
        string body = s;
        body = body.Replace("\r\n", "<br/>");
        body = body.Replace("  ", "&nbsp&nbsp");

        return body;
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        Response.Redirect("updateentry.aspx?id=" + Request.QueryString["id"]);
    }
}
