using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using YABlog.BLL;

public partial class UpdateEntry : System.Web.UI.Page
{
    EntriesAction ent = new EntriesAction();    
    CategoriesAction cat = new CategoriesAction();
    EntryBO entry = null;

    protected void Page_Load(object sender, EventArgs e)
    {
        TextBox2.EnableHtmlMode = false;
        if (Session["UserId"] == null)
        {
            Response.Redirect("Login.aspx");
        }
       
        if (!IsPostBack)
        {
            if (Request.QueryString["id"] == null)
            {
                Response.Redirect("default.aspx");
            }
            
            entry = ent.GetEntryDetails(Convert.ToInt32(Request.QueryString["id"]));

            TextBox1.Text = entry.Subject;
            cat.GetCategories(DropDownList1);

            TextBox2.Text = entry.Body;

            for (int i = 0; i < DropDownList1.Items.Count; ++i)
            {
                if (DropDownList1.Items[i].ToString() == cat.GetCategoryNameById(entry.CAT_ID))
                {
                    DropDownList1.SelectedIndex = i;
                }
            }
        }

        
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        Response.Redirect("ViewEntry.aspx?id=" + Request.QueryString["id"]);
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        if (TextBox1.Text != "")
        {
            ent.UpdateEntry(Convert.ToInt32(Request.QueryString["id"]), DropDownList1.SelectedValue, TextBox1.Text, TextBox2.Text);
            Response.Redirect("ViewEntry.aspx?id=" + Request.QueryString["id"]);
        }
    }
}
