using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using YABlog.BLL;

public partial class MasterPage : System.Web.UI.MasterPage
{
    EntriesAction ent = new EntriesAction();
    CategoriesAction cat = new CategoriesAction();

    public bool SidePaneVisibility
    {
        get 
        {
            return RightSide.Visible;
        }
        set 
        {
            RightSide.Visible = false;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        cat.GetCategories(Repeater2);
        HyperLink1.Text = "All (" + ent.GetEntriesCount(-1) + ")";

        MetaDataAction metaAction = new MetaDataAction();    
        MetaDataBO meta = null;

        metaAction.GetMetaData(out meta);
        Label1.Text = meta.SITENAME;
        Label2.Text = meta.SUBTITLE;

        MenuItem login = new MenuItem("Login", "Login", "", "Login.aspx");
        MenuItem logout = new MenuItem("Logout", "Logout", "", "Login.aspx?action=logout");
        MenuItem go2blog = new MenuItem("Go2Blog", "Go2Blog", "", "~/Default.aspx");

        if (Session["UserId"] == null)
        {
            Menu1.Items.Add(login);
            Menu1.Items.Add(go2blog); 
        }
        else
        {
            Menu1.Items.Add(logout);                       
        }
    }
}
