using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using YABlog.BLL;

public partial class Admin_Login : System.Web.UI.Page
{
    UserActions user = new UserActions();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["action"] == null)
        {
            //do nothing
        }
        else if (Request.QueryString["action"] == "logout")
        {
            Session.Remove("UserId");
            Response.Redirect("login.aspx");
        }
        else if (Request.QueryString["action"] == "login")
        {
            //do nothing for now
        }

        if (Session["UserId"] == null)
        {
            MasterPage master = (MasterPage)this.Master;
            master.SidePaneVisibility = false;
        }

        Label1.Text = "";
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        string username = TextBox1.Text;
        string password = EncryptionManager.Encrypt(TextBox2.Text);

        if (user.ValidateUser(username, password))
        {
            Session["UserId"] = username;
            Response.Redirect("Default.aspx");
        }
        else
        {
            Label1.Text = "Invalid Username and/or Password";
        }
    }
}
