using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using YABlog.BLL;

public partial class _Default : System.Web.UI.Page
{
    EntriesAction ent = new EntriesAction();
    CategoriesAction cat = new CategoriesAction();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["UserId"] == null)
        {
            Response.Redirect("Login.aspx");
        }
       
        if (Request.QueryString["id"] != null)
        {
            int catId = Convert.ToInt32(Request.QueryString["id"]);

            if (catId != 0)
            {
                Label1.Text = "View Blogs under category: " + cat.GetCategoryNameById(catId);
                Repeater1.DataSource = ent.GetEntryListByCategoryId(catId);
                Repeater1.DataBind();  
            }
            else
            {
                ShowAllBlogs();   
            }
        }
        else
        {
            ShowAllBlogs();
        }
    }

    private void ShowAllBlogs()
    {
        Label1.Text = "View All Blogs";

        ent.GetEntryList(Repeater1); 
    }
}
