using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

namespace YABlog.DAL
{
    public class EntriesDb
    {
        public EntriesDb()
        {

        }

        public bool AddEntry(int catId, string subj, string body)
        {
            return Functions.ExecuteNonQuery("AddEntry", new SqlParameter[]{new SqlParameter("@catid", catId), new SqlParameter("@sub", subj),
            new SqlParameter("@body", body), new SqlParameter("@date", DateTime.Now)  });

        }

        public bool UpdateEntry(int id, int catId, string subj, string body)
        {
            return Functions.ExecuteNonQuery("UpdateEntry", new SqlParameter[]{new SqlParameter("@id", id), new SqlParameter("@catid", catId), new SqlParameter("@sub", subj),
            new SqlParameter("@body", body), new SqlParameter("@date", DateTime.Now)  });

        }

        public DataTable GetEntryList()
        {
            return Functions.ExecuteSelectCommand("GetEntries");
        }

        public DataTable GetEntryListByCategoryId(int id)
        {
            SqlParameter p = new SqlParameter("@id", id);

            return Functions.ExecuteParamerizedSelectCommand("GetEntriesByCategoryId", new SqlParameter[] { p });
        }

        public DataTable GetEntryDetails(int id)
        {
            SqlParameter p = new SqlParameter("@id", id);
            return Functions.ExecuteParamerizedSelectCommand("GetEntryDetails", new SqlParameter[] { p });
        }
    }
}
