using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

namespace YABlog.DAL
{
    public class CategoriesDb
    {

        public CategoriesDb()
        {

        }

        public DataTable GetCategories()
        {
            return Functions.ExecuteSelectCommand("GetCategories");
        }

        public int GetCategoryIdByName(string catName)
        {
            SqlParameter par = new SqlParameter("@cat", catName);
            DataTable table = Functions.ExecuteParamerizedSelectCommand("GetCategoryIdByName", new SqlParameter[] { par });

            return (int)table.Rows[0][0];
        }

        public string GetCategoryNameById(int catId)
        {
            SqlParameter par = new SqlParameter("@id", catId);
            DataTable table = Functions.ExecuteParamerizedSelectCommand("GetCategoryNameById", new SqlParameter[] { par });

            return (string)table.Rows[0][0];
        }

        public bool UpdateCategory(int id, string newName)
        {
            SqlParameter par = new SqlParameter("@id", id);
            SqlParameter par2 = new SqlParameter("@newName", newName);

            return Functions.ExecuteNonQuery("UpdateCategory", new SqlParameter[] { par, par2 });
        }

        public bool AddCategory(string name)
        {
            SqlParameter par = new SqlParameter("@name", name);

            return Functions.ExecuteNonQuery("AddCategory", new SqlParameter[] { par });
        }
    }
}
