using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using YABlog.DAL;

namespace YABlog.BLL
{
    public class EntriesAction
    {
        EntriesDb entDb = new EntriesDb();
        CategoriesDb catDb = new CategoriesDb();
        CommentsDb comDb = new CommentsDb();

        public EntriesAction()
        {

        }

        public bool InsertEntry(string catName, string sub, string body)
        {
            return entDb.AddEntry(catDb.GetCategoryIdByName(catName), sub, body);
        }

        public bool UpdateEntry(int id, string catName, string sub, string body)
        {
            return entDb.UpdateEntry(id, catDb.GetCategoryIdByName(catName), sub, body);
        }

        public void GetEntryList(Repeater rep)
        {
            rep.DataSource = entDb.GetEntryList();
            rep.DataBind();
        }

        public int GetEntriesCount(int Cat_id)
        {
            int count = 0;
            if (Cat_id == -1)
            {
                count = entDb.GetEntryList().Rows.Count;
            }
            else
            {
                count = entDb.GetEntryListByCategoryId(Cat_id).Rows.Count;
            }
            return count;
        }

        public EntryBO GetEntryDetails(int id)
        {
            DataTable table = entDb.GetEntryDetails(id);

            EntryBO bo = new EntryBO();

            bo.ID = (int)table.Rows[0]["id"];
            bo.CAT_ID = (int)table.Rows[0]["Cat_id"];
            bo.Body = table.Rows[0]["Body"].ToString();
            bo.Subject = table.Rows[0]["Subject"].ToString();
            bo.Date = Convert.ToDateTime(table.Rows[0]["Date"].ToString());
            bo.Category = (string)catDb.GetCategoryNameById(bo.CAT_ID);

            return bo;
        }

        public DataTable GetEntryListByCategoryId(int id)
        {
            return entDb.GetEntryListByCategoryId(id);
        }
    }
}