﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SlideCarousel.aspx.cs" Inherits="WebSlideProjector.SlideCarousel" %>
<%--
// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--%>
<%@ Import Namespace="System.Reflection" %>
<%@ Register Assembly="IZ.WebFileManager" Namespace="IZ.WebFileManager" TagPrefix="iz" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title id="Title1" runat="server"></title>
    <link id="Link1" runat="server" rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
    <link id="Link2" runat="server" rel="icon" href="favicon.ico" type="image/ico" />
    <meta http-equiv="expires" content="-1" />
    <script type="text/javascript" src="Scripts/jquery-1.6.2.min.js"></script>
    <link rel="stylesheet" href="Styles/WebSlideProjector.css" type="text/css" media="screen" />
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:ImageButton ID="SlideShowButton" runat="server" ImageUrl="~/images/page/Token_Slides.png"
        OnClick="SlideShowButton_Click" CssClass="button_position" ToolTip="Return to Slide Show Screen" />
    <asp:Panel ID="SlideCarouselPanel" runat="server">
        <table id="SlideCarouselTable" class="settings">
            <tr>
                <td colspan="2">
                    <div>
                        <asp:LoginView ID="LoginView1" runat="server">
                            <AnonymousTemplate>
                                You are not logged in
                            </AnonymousTemplate>
                            <LoggedInTemplate>
                                You are logged in as
                            </LoggedInTemplate>
                        </asp:LoginView>
                        <asp:LoginName ID="LoginName1" runat="server" />
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <h2>
                        <span id="TitleSpan" runat="server"></span>
                    </h2>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <asp:Panel ID="WebFileManagePanel" runat="server">
                        <table>
                            <tr>
                                <td colspan="2">
                                    <h3>
                                        Load Images (allowed types: <label id="SlideFileExt" runat="server"></label>, max size KB: <label id="SlideFileMaxSize" runat="server"></label>)</h3>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <div>
                                        <iz:FileManager ID="WebFileManager1" runat="server" Height="300" Width="700" ShowAddressBar="false"
                                            ShowHiddenFilesAndFolders="false" UseLinkToOpenItem="true" DownloadOnDoubleClick="true"
                                            FileViewMode="Details" OnFileUploading="WebFileManager1_FileUploading" OnFileUploaded="WebFileManager1_FileUploaded"
                                            OnItemRenaming="WebFileManager1_ItemRenaming" OnNewFolderCreating="WebFileManager1_NewFolderCreating"
                                            ProhibitedFiles=".exe, .txt, .doc" HiddenFiles=".db" HiddenFilesAndFoldersPrefix="_"
                                            TabIndex="30" EnableContextMenu="true" LinkToOpenItemTarget="_blank">
                                            <FileTypes>
                                                <iz:FileType Extensions="gif" Name="Image" SmallImageUrl="~/images/webfilemgr/lullacons_16x16/doc-type-gif.png">
                                                </iz:FileType>
                                                <iz:FileType Extensions="png" Name="Image" SmallImageUrl="~/images/webfilemgr/lullacons_16x16/doc-type-png.png">
                                                </iz:FileType>
                                                <iz:FileType Extensions="jpg" Name="Image" SmallImageUrl="~/images/webfilemgr/lullacons_16x16/doc-type-jpg.png">
                                                </iz:FileType>
                                                <iz:FileType Extensions="bmp" Name="Image" SmallImageUrl="~/images/webfilemgr/lullacons_16x16/doc-type-bmp.png">
                                                </iz:FileType>
                                                <iz:FileType Extensions="pdf" Name="Image" SmallImageUrl="~/images/webfilemgr/lullacons_16x16/doc-type-pdf.png">
                                                </iz:FileType>
                                                <iz:FileType Extensions="zip" Name="Image" SmallImageUrl="~/images/webfilemgr/lullacons_16x16/file-zip.png">
                                                </iz:FileType>
                                            </FileTypes>
                                            <ToolbarOptions ShowNewFolderButton="true" ShowMoveButton="true" ShowFolderUpButton="true"
                                                ShowCopyButton="true" ShowViewButton="false" ShowRefreshButton="true"></ToolbarOptions>
                                        </iz:FileManager>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                </td>
            </tr>
        </table>
    </asp:Panel>
    </form>
</body>
</html>

