﻿// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Web.Security;

using IZ.WebFileManager;
using DotNetSources;
using WebSlideProjector.Configuration;
using WebSlideProjector.Extensions;

namespace WebSlideProjector
{
    public partial class ProjectorSetup : DotNetSources.Web.UI.Buttons.BoxContextPage
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        /// <summary>   Event handler. Called by Page for load events. </summary>
        ///
        /// <param name="sender">   Source of the event. </param>
        /// <param name="e">        Event information. </param>
        ////////////////////////////////////////////////////////////////////////////////////////////////////

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                this.TitleSpan.InnerText = String.Format("{0} - {1}: Projector Setup", AppSettings.AssemblyName, AppSettings.AssemblyVersion);
                this.Title = String.Format("{0} - {1}: Projector Setup", AppSettings.AssemblyName, AppSettings.AssemblyVersion);

                this.slideShowSettings();
            }
        }

        #region Web Form Designer generated code

        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: This call is required by the ASP.NET Web Form Designer.
            //
            InitializeComponent();
            base.OnInit(e);
        }

        private void InitializeComponent()
        {
            this.Error += new System.EventHandler(this.Page_Error);
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        /// <summary>   Event handler. Called by ProjectorSetup for error events. </summary>
        ///
        /// <param name="sender">   Source of the event. </param>
        /// <param name="e">        Event information. </param>
        ////////////////////////////////////////////////////////////////////////////////////////////////////

        protected void Page_Error(object sender, EventArgs e)
        {
            Response.Redirect("~/ErrorPages/Error.aspx", true);
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        /// <summary>   Event handler. Called by UpdateSettingsButton for click events. </summary>
        ///
        /// <param name="sender">   Source of the event. </param>
        /// <param name="e">        Event information. </param>
        ////////////////////////////////////////////////////////////////////////////////////////////////////

        protected void UpdateSettingsButton_Click(object sender, EventArgs e)
        {
            this.IntervalRegExValidator.Validate();
            this.RefreshRegExValidator.Validate();
            this.TransistionSpeedRegExValidator.Validate();

            if (!this.IntervalRegExValidator.IsValid
                || !this.RefreshRegExValidator.IsValid
                || !this.TransistionSpeedRegExValidator.IsValid
                )
            {
                this.MessageBox.Show(
                    "Submitted change was not valid.",
                    DotNetSources.Web.UI.Buttons.Popup.Icon.Error
                    );
                return;
            }

            Session["SlideShowIntervalSeconds"] = this.SlideShowIntervalSecondsTB.Text;
            Session["SlideShowRefreshMinutes"] = this.SlideShowRefreshMinutesTB.Text;
            Session["SlideShowTransistionSpeedMilliSeconds"] = this.SlideShowTransistionSpeedMilliSecondsTB.Text;
            Session["SlideShowRandomModeRBL"] = this.SlideShowRandomModeRBL.SelectedItem.Value;
            Session["SlideShowControlsModeRBL"] = this.SlideShowControlsModeRBL.SelectedItem.Value;
            Session["SlideShowMouseCursorModeRBL"] = this.SlideShowMouseCursorModeRBL.SelectedItem.Value;

            HttpCookie cookieSettings = new HttpCookie("SlideShowSettings");
            cookieSettings["Version"] = AppSettings.AssemblyVersion;
            cookieSettings["IntervalSeconds"] = Session["SlideShowIntervalSeconds"].ToString();
            cookieSettings["RefreshMinutes"] = Session["SlideShowRefreshMinutes"].ToString();
            cookieSettings["TransistionMilliSeconds"] = Session["SlideShowTransistionSpeedMilliSeconds"].ToString();
            cookieSettings["RandomMode"] = Session["SlideShowRandomModeRBL"].ToString();
            cookieSettings["ControlsMode"] = Session["SlideShowControlsModeRBL"].ToString();
            cookieSettings["MouseCursorMode"] = Session["SlideShowMouseCursorModeRBL"].ToString();
            cookieSettings.Expires = DateTime.Now.AddDays(1d);
            Response.Cookies.Add(cookieSettings);

            this.MessageBox.Show(
                "Submitted change was successfully completed.",
                DotNetSources.Web.UI.Buttons.Popup.Icon.Info
                );
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        /// <summary>   Slide show settings. </summary>
        ////////////////////////////////////////////////////////////////////////////////////////////////////

        private void slideShowSettings()
        {
            this.SlideShowIntervalSecondsTB.Text = Session["SlideShowIntervalSeconds"].ToString();
            this.SlideShowRefreshMinutesTB.Text = Session["SlideShowRefreshMinutes"].ToString();
            this.SlideShowTransistionSpeedMilliSecondsTB.Text = Session["SlideShowTransistionSpeedMilliSeconds"].ToString();
            this.SlideShowRandomModeRBL.SelectedValue = Session["SlideShowRandomModeRBL"].ToString();
            this.SlideShowControlsModeRBL.SelectedValue = Session["SlideShowControlsModeRBL"].ToString();
            this.SlideShowMouseCursorModeRBL.SelectedValue = Session["SlideShowMouseCursorModeRBL"].ToString();
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        /// <summary>   Event handler. Called by SlideButton for click events. </summary>
        ///
        /// <param name="sender">   Source of the event. </param>
        /// <param name="e">        SlideShowImage click event information. </param>
        ////////////////////////////////////////////////////////////////////////////////////////////////////

        protected void SlideShowButton_Click(object sender, ImageClickEventArgs e)
        {
            try
            {
                Response.Redirect("~/Default.aspx", true);
            }
            catch (System.Threading.ThreadAbortException)
            {
                // Ignore
            }
            catch (Exception ex)
            {
                HttpContext ctx = HttpContext.Current;
                string origin = ctx.Request.Url.ToString();
                string exMessageHTML = ex.ToErrorMessageHTML(origin, System.Reflection.MethodBase.GetCurrentMethod().Name);

                Session["SiteError"] = exMessageHTML;

                Response.Redirect("~/ErrorPages/Error.aspx", true);
            }
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        /// <summary>   Raises the error event. </summary>
        ///
        /// <param name="e">    Event information to send to registered event handlers. </param>
        ////////////////////////////////////////////////////////////////////////////////////////////////////

        protected override void OnError(EventArgs e)
        {
            Response.Redirect("~/ErrorPages/Error.aspx", true);

            base.OnError(e);
        }
    }
}