﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ProjectorSetup.aspx.cs"
    Inherits="WebSlideProjector.ProjectorSetup" %>
<%--
// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--%>
<%@ Import Namespace="System.Reflection" %>
<%@ Register Assembly="IZ.WebFileManager" Namespace="IZ.WebFileManager" TagPrefix="iz" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title runat="server"></title>
    <link id="Link1" runat="server" rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
    <link id="Link2" runat="server" rel="icon" href="favicon.ico" type="image/ico" />
    <meta http-equiv="expires" content="-1" />
    <script type="text/javascript" src="Scripts/jquery-1.6.2.min.js"></script>
    <link rel="stylesheet" href="Styles/WebSlideProjector.css" type="text/css" media="screen" />
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:ImageButton ID="SlideShowButton" runat="server" ImageUrl="~/images/page/Token_Slides.png"
        OnClick="SlideShowButton_Click" CssClass="button_position" ToolTip="Return to Slide Show Screen" />
    <asp:Panel ID="ProjectorSetupPanel" runat="server" DefaultButton="UpdateSettingsButton">
        <table id="ProjectorSetupTable" class="settings">
            <tr>
                <td>
                    <h2>
                        <span id="TitleSpan" runat="server"></span>
                    </h2>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Panel ID="SetupPanel" runat="server">
                        <table>
                            <tr>
                                <td colspan="2">
                                    <h3>
                                        Settings:</h3>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="Label1" CssClass="slide_show_label" runat="server" Text="Interval between Slides in Seconds"></asp:Label>
                                </td>
                                <td>
                                    <asp:TextBox ID="SlideShowIntervalSecondsTB" TabIndex="1" runat="server" ValidationGroup="check"></asp:TextBox>
                                    <asp:RegularExpressionValidator ID="IntervalRegExValidator" runat="server" ControlToValidate="SlideShowIntervalSecondsTB"
                                        ErrorMessage="Please Enter Only Numbers" ValidationExpression="^\d+$" ValidationGroup="check"></asp:RegularExpressionValidator>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="Label2" CssClass="slide_show_label" runat="server" Text="Refresh Slides in Minutes"></asp:Label>
                                </td>
                                <td>
                                    <asp:TextBox ID="SlideShowRefreshMinutesTB" TabIndex="2" runat="server" ValidationGroup="check"></asp:TextBox>
                                    <asp:RegularExpressionValidator ID="RefreshRegExValidator" runat="server" ControlToValidate="SlideShowRefreshMinutesTB"
                                        ErrorMessage="Please Enter Only Numbers" ValidationExpression="^\d+$" ValidationGroup="check"></asp:RegularExpressionValidator>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="Label3" CssClass="slide_show_label" runat="server" Text="Slide Transistion Speed in MilliSeconds"></asp:Label>
                                </td>
                                <td>
                                    <asp:TextBox ID="SlideShowTransistionSpeedMilliSecondsTB" TabIndex="3" runat="server"
                                        ValidationGroup="check"></asp:TextBox>
                                    <asp:RegularExpressionValidator ID="TransistionSpeedRegExValidator" runat="server"
                                        ControlToValidate="SlideShowTransistionSpeedMilliSecondsTB" ErrorMessage="Please Enter Only Numbers"
                                        ValidationExpression="^\d+$" ValidationGroup="check"></asp:RegularExpressionValidator>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="Label5" CssClass="slide_show_label" runat="server" Text="Show Slides in Random Order"></asp:Label>
                                </td>
                                <td>
                                    <asp:RadioButtonList ID="SlideShowRandomModeRBL" TabIndex="5" runat="server" RepeatDirection="Horizontal"
                                        CssClass="slide_show_radio_button">
                                        <asp:ListItem Text="On" Value="1"></asp:ListItem>
                                        <asp:ListItem Text="Off" Value="0"></asp:ListItem>
                                    </asp:RadioButtonList>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="Label6" CssClass="slide_show_label" runat="server" Text="Show Controls"
                                        ToolTip="Show Controls at botton of the Slide Screen"></asp:Label>
                                </td>
                                <td>
                                    <asp:RadioButtonList ID="SlideShowControlsModeRBL" TabIndex="6" runat="server" RepeatDirection="Horizontal"
                                        CssClass="slide_show_radio_button" ToolTip="Show Controls at botton of the Slide Screen">
                                        <asp:ListItem Text="On" Value="1"></asp:ListItem>
                                        <asp:ListItem Text="Off" Value="0"></asp:ListItem>
                                    </asp:RadioButtonList>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="Label7" CssClass="slide_show_label" runat="server" Text="Show Mouse Cursor in Slide Screen"
                                        ToolTip="Not all browsers support this functionality."></asp:Label>
                                </td>
                                <td>
                                    <asp:RadioButtonList ID="SlideShowMouseCursorModeRBL" TabIndex="7" runat="server"
                                        RepeatDirection="Horizontal" CssClass="slide_show_radio_button" ToolTip="Not all browsers support this functionality.">
                                        <asp:ListItem Text="On" Value="1"></asp:ListItem>
                                        <asp:ListItem Text="Off" Value="0"></asp:ListItem>
                                    </asp:RadioButtonList>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                </td>
                                <td>
                                    <asp:Button ID="UpdateSettingsButton" Style="float: right;" TabIndex="20" runat="server"
                                        Text="Update Settings" OnClick="UpdateSettingsButton_Click" CssClass="slide_show_radio_button" />
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <hr />
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                </td>
            </tr>
        </table>
    </asp:Panel>
    </form>
</body>
</html>
