﻿// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using System.IO;
using System.Text.RegularExpressions;
using System.Configuration;
using System.Diagnostics;
using System.Web.Configuration;

using WebSlideProjector.Extensions;
using WebSlideProjector.Configuration;
using WebSlideProjector.EventLogs;

namespace WebSlideProjector
{
    public class Global : System.Web.HttpApplication
    {
        protected void Application_Start(object sender, EventArgs e)
        {
        }

        protected void Session_Start(object sender, EventArgs e)
        {
            if (Request.Cookies["SlideShowSettings"] != null)
            {
                bool deletedCookie = false;
                if (Request.Cookies["SlideShowSettings"]["Version"] != null)
                {
                    string version = Request.Cookies["SlideShowSettings"]["Version"];
                    if (0 != String.Compare(AppSettings.AssemblyVersion, version)) 
                    {
                        HttpCookie cookie = new HttpCookie("SlideShowSettings");
                        cookie.Expires = DateTime.Now.AddDays(-1d);
                        Response.Cookies.Add(cookie);
                        deletedCookie = true;
                    }
                }

                if (!deletedCookie)
                {
                    Session["SlideShowIntervalSeconds"] =
                        (null != Request.Cookies["SlideShowSettings"]["IntervalSeconds"])
                        ? Request.Cookies["SlideShowSettings"]["IntervalSeconds"]
                        : AppSettings.SlideShowIntervalSeconds;

                    Session["SlideShowRefreshMinutes"] =
                        (null != Request.Cookies["SlideShowSettings"]["RefreshMinutes"])
                        ? Request.Cookies["SlideShowSettings"]["RefreshMinutes"]
                        : AppSettings.SlideShowRefreshMinutes;

                    Session["SlideShowTransistionSpeedMilliSeconds"] =
                        (null != Request.Cookies["SlideShowSettings"]["SlideShowSettings"])
                        ? Request.Cookies["SlideShowSettings"]["SlideShowSettings"]
                        : AppSettings.SlideShowTransistionSpeedMilliSeconds;

                    Session["SlideShowMaxImageSizeKB"] =
                        (null != Request.Cookies["SlideShowSettings"]["MaxImageSizeKB"])
                        ? Request.Cookies["SlideShowSettings"]["MaxImageSizeKB"]
                        : AppSettings.SlideShowMaxImageSizeKB;

                    Session["SlideShowRandomModeRBL"] =
                        (null != Request.Cookies["SlideShowSettings"]["RandomMode"])
                        ? Request.Cookies["SlideShowSettings"]["RandomMode"]
                        : AppSettings.SlideShowRandomMode;

                    Session["SlideShowControlsModeRBL"] =
                        (null != Request.Cookies["SlideShowSettings"]["ControlsMode"])
                        ? Request.Cookies["SlideShowSettings"]["ControlsMode"]
                        : AppSettings.SlideShowControlsMode;

                    Session["SlideShowMouseCursorModeRBL"] =
                        (null != Request.Cookies["SlideShowSettings"]["MouseCursorMode"])
                        ? Request.Cookies["SlideShowSettings"]["MouseCursorMode"]
                        : AppSettings.SlideShowMouseCursorMode;

                    return;
                }
            }

            Session["SlideShowFolder"]                          = AppSettings.SlideShowFolder;
            Session["SlideShowIntervalSeconds"]                 = AppSettings.SlideShowIntervalSeconds;
            Session["SlideShowRefreshMinutes"]                  = AppSettings.SlideShowRefreshMinutes;
            Session["SlideShowTransistionSpeedMilliSeconds"]    = AppSettings.SlideShowTransistionSpeedMilliSeconds;
            Session["SlideShowMaxImageSizeKB"]                  = AppSettings.SlideShowMaxImageSizeKB;
            Session["SlideShowRandomModeRBL"]                   = AppSettings.SlideShowRandomMode;
            Session["SlideShowControlsModeRBL"]                 = AppSettings.SlideShowControlsMode;
            Session["SlideShowMouseCursorModeRBL"]              = AppSettings.SlideShowMouseCursorMode;

            HttpCookie cookieSettings                           = new HttpCookie("SlideShowSettings");
            cookieSettings["Version"]                           = AppSettings.AssemblyVersion;
            cookieSettings["IntervalSeconds"]                   = Session["SlideShowIntervalSeconds"].ToString();
            cookieSettings["RefreshMinutes"]                    = Session["SlideShowRefreshMinutes"].ToString();
            cookieSettings["TransistionMilliSeconds"]           = Session["SlideShowTransistionSpeedMilliSeconds"].ToString();
            cookieSettings["MaxImageSizeKB"]                    = Session["SlideShowMaxImageSizeKB"].ToString();
            cookieSettings["RandomMode"]                        = Session["SlideShowRandomModeRBL"].ToString();
            cookieSettings["ControlsMode"]                      = Session["SlideShowControlsModeRBL"].ToString();
            cookieSettings["MouseCursorMode"]                   = Session["SlideShowMouseCursorModeRBL"].ToString();
            cookieSettings.Expires                              = DateTime.Now.AddDays(1d);
            Response.Cookies.Add(cookieSettings);
        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {
            Exception ex = Server.GetLastError();
            if (null != ex)
            {
                HttpContext ctx = HttpContext.Current;
                string origin = (null != ctx) ? ctx.Request.Url.ToString() : "Application_Error";
                var filePath = Context.Request.FilePath;

                string exMessage = ex.ToErrorMessageString(origin, System.Reflection.MethodBase.GetCurrentMethod().Name);

                Server.ClearError();

                WebEventLog log = new WebEventLog();
                log.LogError(exMessage);
            }
        }

        protected void Session_End(object sender, EventArgs e)
        {
            HttpCookie cookieSettings                   = new HttpCookie("SlideShowSettings");
            cookieSettings["Version"]                   = AppSettings.AssemblyVersion;
            cookieSettings["IntervalSeconds"]           = Session["SlideShowIntervalSeconds"].ToString();
            cookieSettings["RefreshMinutes"]            = Session["SlideShowRefreshMinutes"].ToString();
            cookieSettings["TransistionMilliSeconds"]   = Session["SlideShowTransistionSpeedMilliSeconds"].ToString();
            cookieSettings["MaxImageSizeKB"]            = Session["SlideShowMaxImageSizeKB"].ToString();
            cookieSettings["RandomMode"]                = Session["SlideShowRandomModeRBL"].ToString();
            cookieSettings["ControlsMode"]              = Session["SlideShowControlsModeRBL"].ToString();
            cookieSettings["MouseCursorMode"]           = Session["SlideShowMouseCursorModeRBL"].ToString();
            cookieSettings.Expires                      = DateTime.Now.AddDays(1d);
            Response.Cookies.Add(cookieSettings);
        }

         protected void Application_End(object sender, EventArgs e)
        {

        }
    }
}