﻿// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace WebSlideProjector.Extensions
{
    public static class ExceptionExtensions
    {
        public static string ToErrorMessageString(this Exception ex)
        {
            string exMessage =
                  "\nSource: " + ex.Source
                + "\nMessage: " + ex.Message
                + "\nBaseException: " + ex.GetBaseException() 
                + "\nStack trace: " + ex.StackTrace
                // + "\nInnerException Message: " + ex.InnerException.Message
               ;
            return exMessage;
        }

        public static string ToErrorMessageHTML(this Exception ex)
        {
            string exMessage =
                  "<br><b>Source:</b> " + ex.Source
                + "<br><b>Message:</b> " + ex.Message
                + "<br><b>BaseException:</b> " + ex.GetBaseException()
                + "<br><b>Stack trace:</b> " + ex.StackTrace
                // + "\nInnerException Message: " + ex.InnerException.Message
               ;

            return exMessage.Replace(Environment.NewLine, @"<br>");
        }

        public static string ToErrorMessageString(this Exception ex, string origin, string location)
        {
            string exMessage =
                  "\nOrigin: " + origin
                + "\nLocation: " + location
                + "\nSource: " + ex.Source
                + "\nMessage: " + ex.Message
                + "\nType: " + ex.GetType().ToString()
                + "\nBaseException: " + ex.GetBaseException().GetType().ToString()
                + "\nStack trace: " + ex.StackTrace
                // + "\nInnerException Message: " + ex.InnerException.Message
               ;
            return exMessage;
        }

        public static string ToErrorMessageHTML(this Exception ex, string origin, string location)
        {
            string exMessage =
                  "<br><b>Origin:</b> " + origin
                + "<br><b>Location:</b> " + location
                + "<br><b>Source:</b> " + ex.Source
                + "<br><b>Message:</b> " + ex.Message
                + "<br><b>Type:</b> " + ex.GetType().ToString()
                + "<br><b>BaseException:</b> " + ex.GetBaseException().GetType().ToString()
                + "<br><b>Stack trace:</b> " + ex.StackTrace
                // + "\nInnerException Message: " + ex.InnerException.Message
               ;

            return exMessage.Replace(Environment.NewLine, @"<br>");
        }
    }
}