﻿// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using WebSlideProjector.Extensions;
using WebSlideProjector.Configuration;

namespace WebSlideProjector.ErrorPages
{
    public partial class Error : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            this.TitleSpan.InnerText = String.Format("{0} - {1}: Error", AppSettings.AssemblyName, AppSettings.AssemblyVersion);
            this.Title = String.Format("{0} - {1}: Error", AppSettings.AssemblyName, AppSettings.AssemblyVersion);

            HttpContext ctx = HttpContext.Current;
            string exMessageHTML = String.Empty;

            if (null != Session["SiteError"])
            {
                exMessageHTML = Session["SiteError"].ToString();
                Session["SiteError"] = null;
            }
            else
            {
                Exception ex = Server.GetLastError();
                if (null != ex)
                {
                    string origin = ctx.Request.Url.ToString();
                    exMessageHTML = ex.ToErrorMessageHTML(origin, System.Reflection.MethodBase.GetCurrentMethod().Name);
                    Server.ClearError();
                }         
            }

            this.ErrorSpan.InnerHtml = exMessageHTML.ToString();

            //WebEventLog log = new WebEventLog();
            //log.LogException(ex, origin);     
        }

        protected void SlideShowButton_Click(object sender, ImageClickEventArgs e)
        {
            try
            {
                Response.Redirect("~/Default.aspx", true);
            }
            catch (System.Threading.ThreadAbortException)
            {
                // Ignore
            }
            catch (Exception ex)
            {
                HttpContext ctx = HttpContext.Current;
                string origin = ctx.Request.Url.ToString();
                string exMessageHTML = ex.ToErrorMessageHTML(origin, System.Reflection.MethodBase.GetCurrentMethod().Name);

                this.ErrorSpan.InnerHtml = exMessageHTML.ToString();
            }
        }
    }
}