﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="WebSlideProjector._Default" %>
<%--
// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head id="Head1" runat="server">
    <title id="Title1" runat="server"></title>
    <link id="Link1" runat="server" rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
    <link id="Link2" runat="server" rel="icon" href="favicon.ico" type="image/ico" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=8" />
    <link rel="stylesheet" href="Styles/supersized.css" type="text/css" media="screen" />
    <link rel="stylesheet" href="Styles/WebSlideProjector.css" type="text/css" media="screen" />
    <script type="text/javascript" src="Scripts/jquery-1.6.2.min.js"></script>
    <script type="text/javascript" src="Scripts/supersized.3.1.3.min.js"></script>
    <!-- Full Screen Browser scripts -->
    <script type="text/javascript">
    function initKeydownEvents() {
        if (document.addEventListener) {
            document.addEventListener("keydown", keydown, false);
        }
        else if (document.attachEvent) {
            document.attachEvent("onkeydown", keydown);
        }
        else {
            document.onkeydown = keydown;
        }
    }

    function hideMouseCursor() {
        $('body').css('cursor', 'none');
    }

    function showMouseCursor() {
        $('body').css('cursor', 'default'); 
    }

    function manageMouseCursor() {
		var sessionSlideShowMouseCursorMode = <%=Session["SlideShowMouseCursorModeRBL"].ToString() %>;
		var slideShowMouseCursorMode = parseInt(sessionSlideShowMouseCursorMode);

        if (1 == slideShowMouseCursorMode) {
            showMouseCursor();
        } else {
            hideMouseCursor();
        }
    }

    function keydown(e) {
        if (!e) { e = event; }
        if (122 == e.keyCode) { location.reload(); manageMouseCursor(); }
        if (113 == e.keyCode) { location.href = "ProjectorSetup.aspx"; }
    }

    function showSlideControls() {
        $("#controls-wrapper").show();
        $("#controls-wrapper").css("background", "url(../images/controls/nav-bg.png) repeat-x");
        $("#controls-wrapper").css("filter", "alpha(opacity=50)");
        $("#slidecounterspan").text("/");
        $("#open-controls").css("display", "none");
        $("#close-controls").css("display", "block");
    }

    function hideSlideControls() {
        $("#controls-wrapper").hide();
        $("#controls-wrapper").css("background", "");
        $("#controls-wrapper").css("filter", "");
        $("#slidecounterspan").text("");
        $("#open-controls").css("display", "block");
        $("#close-controls").css("display", "none");
    }

    function onmousemoveMouseCursor() {
        showMouseCursor();

        var onmousestop = function () {
            manageMouseCursor();
        }, thread;

        clearTimeout(thread);
        thread = setTimeout(onmousestop, 500);
    }

    </script>
    <!-- Slide Show jQuery Controls -->
    <script type="text/javascript">
	jQuery(function ($) {
		var hiddenSlidesJSON = $("#hiddenSlidesJSON").val();
		var slidesJSON = jQuery.parseJSON(hiddenSlidesJSON);

		var sessionIntervalSeconds = <%=Session["SlideShowIntervalSeconds"].ToString() %>;
		var slidesInterval = parseInt(sessionIntervalSeconds) * 1000;

		var hiddenSlidesTransistionMode = $("#hiddenSlidesTransistionMode").val();
		var slidesTransistionMode = parseInt(hiddenSlidesTransistionMode);

		var sessionSlidesTransistionSpeed = <%=Session["SlideShowTransistionSpeedMilliSeconds"].ToString() %>;
		var slidesTransistionSpeed = parseInt(sessionSlidesTransistionSpeed);

		var sessionSlideShowRandomMode = <%=Session["SlideShowRandomModeRBL"].ToString() %>;
		var slideShowRandomMode = parseInt(sessionSlideShowRandomMode);

		var sessionSlideShowControlsMode = <%=Session["SlideShowControlsModeRBL"].ToString() %>;
		var slideShowControlsMode = parseInt(sessionSlideShowControlsMode);

		var sessionSlideShowMouseCursorMode = <%=Session["SlideShowMouseCursorModeRBL"].ToString() %>;
		var slideShowMouseCursorMode = parseInt(sessionSlideShowMouseCursorMode);

        var indexStartSlide = 1;
        var modeRandomSlides = 0;

        if ( 1 == slideShowRandomMode) {
            indexStartSlide = 0;
            modeRandomSlides = 1;
        }
 
        if (1 == slideShowControlsMode) {
            showSlideControls();
        } else {
            hideSlideControls();
            $("#open-controls").css("display", "none");
        }

        if (1 == slideShowMouseCursorMode) {
            showMouseCursor();
        } else {
            hideMouseCursor();
        }

		$.supersized({

		    //Functionality
		    slideshow: 1, 	                            //Slideshow on/off
		    autoplay: 1, 	                            //Slideshow starts playing automatically
		    start_slide: indexStartSlide,               //Start slide (0 is random)
		    random: modeRandomSlides,                   //Randomize slide order (Ignores start slide)
		    slide_interval: slidesInterval,             //Length between transitions
		    transition: slidesTransistionMode,          //0-None, 1-Fade, 2-Slide Top, 3-Slide Right, 4-Slide Bottom, 5-Slide Left, 6-Carousel Right, 7-Carousel Left
		    transition_speed: slidesTransistionSpeed,   //Speed of transition
		    new_window: 1, 	                            //Image links open in new window/tab
		    pause_hover: 0, 	                        //Pause slideshow on hover
		    keyboard_nav: 1, 	                        //Keyboard navigation on/off
		    performance: 2, 	                        //0-Normal, 1-Hybrid speed/quality, 2-Optimizes image quality, 3-Optimizes transition speed // (Only works for Firefox/IE, not Webkit)
		    image_protect: 1, 	                        //Disables image dragging and right click with Javascript
		    image_path: 'images/controls/',             //Default image path

		    //Size & Position
		    min_width: 0, 	                            //Min width allowed (in pixels)
		    min_height: 0, 	                            //Min height allowed (in pixels)
		    vertical_center: 1, 	                    //Vertically center background
		    horizontal_center: 1, 	                    //Horizontally center background
		    fit_portrait: 1, 	                        //Portrait images will not exceed browser height
		    fit_landscape: 1, 	                        //Landscape images will not exceed browser width

		    //Components
		    navigation: slideShowControlsMode, 	        //Slideshow controls on/off
		    slide_counter: slideShowControlsMode, 	    //Display slide numbers
		    slide_captions: slideShowControlsMode, 	    //Slide caption (Pull from "title" in slides array)

		    //Slideshow Images 
		    slides: slidesJSON                          //Serialized data structure of a set of SlideShow Images using JSON

		});

	});
		    
    </script>
</head>
<body onmousemove="javascript:onmousemoveMouseCursor();">
    <form id="form1" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:Timer runat="server" ID="timerSlidesRefresh" OnTick="SlidesRefresh_Tick" />
    <asp:ImageButton ID="ProjectorSetupButton" runat="server" ImageUrl="~/images/page/Token_Gear.png"
        CssClass="button_position" OnClick="ProjectorSetupButton_Click" ToolTip="Goto Projector Setup"
        Height="48px" Width="48px" />
    <asp:ImageButton ID="SlideCarouselButton" runat="server" ImageUrl="~/images/page/Token_FolderSlides.png"
        CssClass="button_position" OnClick="SlideCarouselButton_Click" ToolTip="Goto Slide Carousel"
        Height="48px" Width="48px" />
    <input id="hiddenSlidesJSON" type="hidden" runat="server" />
    <input id="hiddenSlidesTransistionMode" type="hidden" runat="server" />
    <div id="webslideshow">
        <!--Thumbnail Navigation-->
        <div id="prevthumb">
        </div>
        <div id="nextthumb">
        </div>
        <!--Control Bar-->
        <img id="open-controls" src="images/controls/open.png" alt="Show Controls" class="slide_show_open_button"
            title="Show Controls" onclick="javascript:showSlideControls();" />
        <div id="controls-wrapper" class="slide_show_controls">
            <img id="close-controls" src="images/controls/close.png" alt="Hide Controls" class="slide_show_close_button"
                title="Hide Controls" onclick="javascript:hideSlideControls();" />
            <div id="controls">
                <!--Slide counter-->
                <div id="slidecounter">
                    <span class="slidenumber"></span><span id="slidecounterspan"></span><span class="totalslides">
                    </span>
                </div>
                <!--Slide captions displayed here-->
                <div id="slidecaption">
                </div>
                <!--Navigation-->
                <div id="navigation">
                    <img id="prevslide" src="images/controls/back_dull.png" alt="" />
                    <img id="pauseplay" src="images/controls/pause_dull.png" alt="" />
                    <img id="nextslide" src="images/controls/forward_dull.png" alt="" />
                </div>
            </div>
        </div>
    </div>
    </form>
</body>
<script type="text/javascript">
    initKeydownEvents();
</script>
</html>
