﻿// Copyright (C) 2012 Jeff Tanner <jeff00seattle@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Configuration;
using System.Reflection; 
using System.Runtime.CompilerServices;

namespace WebSlideProjector.Configuration
{
    public class AppSettings
    {
        public static string SlideShowIntervalSeconds
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowIntervalSeconds"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowIntervalSeconds' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowIntervalSeconds"];
            }
        }

        public static string SlideShowTransistionSpeedMilliSeconds
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowTransistionSpeedMilliSeconds"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowTransistionSpeedMilliSeconds' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowTransistionSpeedMilliSeconds"];
            }
        }

        public static string SlideShowRefreshMinutes
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowRefreshMinutes"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowRefreshMinutes' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowRefreshMinutes"];
            }
        }

        public static string SlideShowMaxImageSizeKB
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowMaxImageSizeKB"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowMaxImageSizeKB' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowMaxImageSizeKB"];
            }
        }

        public static string SlideShowRandomMode
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowRandomModeRBL"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowRandomModeRBL' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowRandomModeRBL"];
            }
        }

        public static string SlideShowControlsMode
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowControlsModeRBL"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowControlsModeRBL' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowControlsModeRBL"];
            }
        }

        public static string SlideShowMouseCursorMode
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowMouseCursorModeRBL"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowControlsMode' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowMouseCursorModeRBL"];
            }
        }

        public static string SlideShowFolder
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowFolder"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowFolder' not defined.");
                }
                return WebConfigurationManager.AppSettings["SlideShowFolder"];
            }
        }

        public static string SlideShowFileExtensions
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowFileExtensions"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowFileExtensions' not defined.");
                }

                return WebConfigurationManager.AppSettings["SlideShowFileExtensions"];           
            }
        }

        public static HashSet<string> SlideShowFileExtensionSet
        {
            get
            {
                string strExt = AppSettings.SlideShowFileExtensions;
                List<string> listExt = strExt.Split(',').Select(p => p.Trim()).ToList();
                return new HashSet<string>(listExt, StringComparer.OrdinalIgnoreCase);
            }
        }

        public static HashSet<string> SlideShowFileTypes
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowFileTypes"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowFileTypes' not defined.");
                }

                string strExt = WebConfigurationManager.AppSettings["SlideShowFileTypes"];
                List<string> listExt = strExt.Split(',').Select(p => p.Trim()).ToList();
                return new HashSet<string>(listExt, StringComparer.OrdinalIgnoreCase);
            }
        }

        public static HashSet<string> SlideShowExemptFolders
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideShowExemptFolders"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideShowExemptFolders' not defined.");
                }

                string strExt = WebConfigurationManager.AppSettings["SlideShowExemptFolders"];
                List<string> listExt = strExt.Split(',').Select(p => p.Trim()).ToList();
                return new HashSet<string>(listExt, StringComparer.OrdinalIgnoreCase);
            }
        }

        public static int CookieExpireInMinutes
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["CookieExpireInMinutes"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'CookieExpireInMinutes' not defined.");
                }

                return Convert.ToInt32(WebConfigurationManager.AppSettings["CookieExpireInMinutes"]);
            }
        }

        public static bool SlideCarouselLoginMode
        {
            get
            {
                if (String.IsNullOrEmpty(WebConfigurationManager.AppSettings["SlideCarouselLoginMode"]))
                {
                    throw new System.Configuration.ConfigurationErrorsException(
                        "WebSlideProjector appSettings 'SlideCarouselLoginMode' not defined.");
                }

                return WebConfigurationManager.AppSettings["SlideCarouselLoginMode"].ToUpper().Equals("ON");
            }
        }

        public static string AssemblyName
        {
            get
            {
                return System.Reflection.Assembly.GetExecutingAssembly().GetName().Name;
            }
        }

        public static string AssemblyVersion
        {
            get
            {
                return System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString();
            }
        }
    }
}