﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.OleDb;
using System.Text;
using System.Web;

namespace TableViewer
{
  /// <summary>
  /// Select table data from
  /// </summary>
  public class SelectionHandler : IHttpHandler
  {

    public void ProcessRequest(HttpContext context)
    {
      context.Response.ContentType = "application/octet-stream"; //alows any type of data (binary response)
      //context.Response.Write("Hello " + context.Request.QueryString["TableName"]);

      getTableData(context);
    }

    public void getTableData(HttpContext context)
    {
      try
      {
        string sTableName = context.Request.QueryString["TableName"];
        string sJson = "Failed to get result";

        string cmdText = "SELECT * FROM [" + sTableName + "] ";
        OleDbCommand command = new OleDbCommand(cmdText);
        string connectionString = ConfigurationManager.ConnectionStrings["NwindDb"].ConnectionString;
        using (OleDbConnection connection = new OleDbConnection(connectionString))
        {
          command.Connection = connection;
          connection.Open();
          using (OleDbDataReader reader = command.ExecuteReader())
          {
            sJson = ReadToJson(reader);
          }
        }
        context.Response.Write(sJson);
      }
      catch (Exception ex)
      {
        context.Response.Write("Error in getTableData: " + ex.Message);
      }
    }

    private string ReadToJson(OleDbDataReader reader)
    {
      try
      {
        List<string> cols = new List<string>(20);
        int ncols = reader.FieldCount;
        for (int i = 0; i < ncols; ++i)
        {
          cols.Add(reader.GetName(i));
        }
        StringBuilder sbJCol = new StringBuilder("[");
        for (int k = 0; k < ncols; ++k)
        {
          sbJCol.AppendFormat("\"{0}\",", cols[k]);
        }
        sbJCol.Replace(',', ']', sbJCol.Length - 1, 1);

        StringBuilder sbJson = new StringBuilder("[");
        //process each row
        string sValue;

        while (reader.Read())
        {
          sbJson.Append('[');
          for (int k = 0; k < ncols; ++k)
          {
            sValue = reader[cols[k]].ToString();
            if (sValue == "System.Byte[]")
            {
              sbJson.Append("\"N.A.\","); //binary values are not available
            }
            else
            {
              sValue = sValue.Replace("\"","'");
              if (sValue.Length == 0)
              {
                sValue = " ";
              }
              sbJson.AppendFormat("\"{0}\",", sValue);
            }
          }
          sbJson.Replace(',', ']', sbJson.Length - 1, 1);
          sbJson.Append(',');
        }
        sbJson.Replace(',', ']', sbJson.Length - 1, 1);

        return String.Concat("{\"Columns\":", sbJCol.ToString(), ",\"Rows\":", sbJson.ToString(), "}");
      }
      catch (Exception ex)
      {
        return String.Concat("Error in ReadToJson: ", ex.Message);
      }
    }

    public bool IsReusable
    {
      get
      {
        return false;
      }
    }
  }
}
