﻿using System;
using System.Web.Script.Serialization;
using System.Web.UI;

namespace TableViewer
{
  public partial class SaveCSV : System.Web.UI.Page
  {
    protected void Page_Load(object sender, EventArgs e)
    {
      Session["_bExportCSVCalled"] = "false";
      if (!IsPostBack)
      {
        lnkExport.Attributes.Add("onclick", "window.top.DownloadTable();");
        Session["_FileName"] = Context.Request.QueryString["FileName"];
      }
      else
      {
        string sData = Context.Request.Form["TableData"];
        if (String.IsNullOrEmpty(sData)) { return; }
        ExportCSV(sData);
      }
    }

    public void ExportCSV(string sData)
    {
      Session["_bExportCSVCalled"] = "true";

      string FileName = Session["_FileName"].ToString();
      string fileName;
      if (String.IsNullOrEmpty(FileName))
      {
        fileName = "CrimeData.csv";
      }
      else
      {
        fileName = FileName;
      }

      Context.Response.Clear();
      Context.Response.BufferOutput = true;
      Context.Response.ContentType = "text/csv";
      Context.Response.AddHeader("Content-Disposition", "attachment; filename=" + fileName);

      //Context.Response.Write("Test1,Test2");
      JavaScriptSerializer serializer = new JavaScriptSerializer();
      TableData data = serializer.Deserialize<TableData>(sData);
      //write column header names
      int k = data.Columns.Length;
      for (int i = 0; i < k; ++i)
      {
        Context.Response.Write(data.Columns[i].ColumnNames);
        Context.Response.Write(Environment.NewLine);
      }

      //write data
      k = data.Rows.Length;
      for (int i = 0; i < k; ++i)
      {
        Context.Response.Write(data.Rows[i].row);
        Context.Response.Write(Environment.NewLine);
      }
      Context.ApplicationInstance.CompleteRequest();
      //using CompleteRequest() instead of context.Response.End 
      // for clean way to end Page request without exceptions (msdn recomended).
      //Then override of Render is required to prevent writing default page output (see below).
    }

    protected override void Render(HtmlTextWriter writer)
    {
      bool bExportCSVCalled = Convert.ToBoolean(Session["_bExportCSVCalled"]);
      if (bExportCSVCalled)
      {
        Context.Response.Flush();
        return; //stop the rest of the output from being written
      }
      base.Render(writer);
    }

  }

  public class columns
  {
    public string ColumnNames;
  }

  public class rows
  {
    public string row;
  }

  [Serializable]
  public class TableData
  {
    public columns[] Columns;
    public rows[] Rows;
  }
}
