<?php

include_once("db_config.php");
include_once("class.error_handler.php");


class SendMail {
	
	public function _sendMail($to,$s_name,$s_mail,$subject,$body) {
	
		$body .= "\n\n---------------------------\n";
		$body .= "Mail sent by: $s_name <$s_mail>\n";
		$body .= "From Simplified Software's Web Mail Client\n";
		$body .= "PHP VERSION: ".phpversion()."\n";
		
		
		$header = "From: $s_name <$s_mail>\n";
		$header .= "Reply-To: $s_name <$s_mail>\n";
		$header .= "X-Mailer: PHP/" . phpversion() . "\n";
		$header .= "X-Priority: 1";
		
		$response = mail($to, $subject, $body, $header);
		
		if(!$response) {
			Error_Handler::logError(
				array(
					0 => "When trying to send an email to: $to, From: $s_name <$s_mail> an error occurred.", 
					1 => "To: $to\nFrom: $s_name <$s_mail>\nSubject: $subject\nBody: $body\nHeaders: $header"
					),
				__FILE__,
				__LINE__
			);
		}
		
		return $response;
		
	}
	
}